package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DispatchAccountType;
import lombok.Data;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;

@TableName(value = "tenant_accounts",autoResultMap = true)
@Data
public class TenantAccountEntity extends EntityAbstract implements Aggregate {
    @TableField(value = "id")
    private Long id;

    @TableField(value = "device_no")
    private String deviceNo;

    @TableField(value = "device_type",typeHandler = org.apache.ibatis.type.EnumOrdinalTypeHandler.class)
    private DispatchAccountType deviceType;

    @TableField(value = "logo")
    private String logo;

    @TableField(value = "title")
    private String title;

    @TableField(value = "sos_enabled")
    private Boolean sosEnabled;

    @TableField(value = "sos_key")
    private String sosKey;

    @TableField(value = "sos_switch_time")
    private Timestamp sosSwitchTime;

    @TableField(value = "last_modifier_id")
    private String lastModifierId;

    @TableField(value = "last_modifier_name")
    private String lastModifierName;

    @TableField(value = "last_modified_time")
    private Timestamp lastModifiedTime;

    @TableField(value = "creator_id")
    private String creatorId;

    @TableField(value = "creator_name")
    private String creatorName;

    @TableField(value = "created_time")
    private Timestamp createdTime;


    /**
     * 读取设置APP的学习指引的时间
     */
    @TableField(value = "read_instruction_time")
    private Timestamp readInstructionTime;

    @TableField(value = "alarm_bell")
    private String alarmBell;

    public TenantAccountEntity() {
        Timestamp now = Timestamp.from(Instant.now());
        this.setCreatedTime(now);
        this.setSosSwitchTime(now);
    }

    public static TenantAccountEntity create(Long id,
                                             String deviceNo,
                                             DispatchAccountType deviceType,
                                             String logo,
                                             String title,
                                             Boolean sosEnabled,
                                             String sosKey,
                                             String creatorId,
                                             String creatorName){
        TenantAccountEntity tenantAccountEntity = new TenantAccountEntity();
        tenantAccountEntity.setId(id);
        tenantAccountEntity.setDeviceNo(deviceNo);
        tenantAccountEntity.setDeviceType(deviceType);
        tenantAccountEntity.setLogo(logo);
        tenantAccountEntity.setTitle(title);
        tenantAccountEntity.setSosEnabled(sosEnabled);
        tenantAccountEntity.setSosKey(sosKey);
        tenantAccountEntity.setCreatorId(creatorId);
        tenantAccountEntity.setCreatorName(creatorName);
        return tenantAccountEntity;
    }

    public void updateReadInstructionTime() {
        this.setReadInstructionTime(Timestamp.from(Instant.now()));
    }

    public void updateSosAlarmBell(String alarmBell) {
        this.setAlarmBell(alarmBell);
    }
}
