package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.open.infrastructures.constants.BusinessConstants;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RollCallStatus;
import com.bcxin.tenant.open.infrastructures.enums.RollCallType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.kafka.common.protocol.types.Field;

import java.sql.Timestamp;
import java.time.Instant;

/**
 * 点名历史
 */
@Data
@TableName(value = "vga_roll_call_employee_histories",autoResultMap = true)
public class RollCallEmployeeHistoryEntity extends EntityAbstract implements Aggregate {
    @TableId("id")
    private Long id;

    @TableField("roll_call_id")
    private Long rollCallId;

    @TableField("roll_call_employee_id")
    private String rollCallEmployeeId;


    @TableField("called_employee_id")
    private String calledEmployeeId;

    @TableField("room_id")
    private String roomId;

    @TableField(value = "status", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private RollCallStatus status;

    @TableField(value = "call_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private RollCallType callType;

    @TableField("created_time")
    private Timestamp createdTime;

    /**
     * 执行此动作的人
     */
    @TableField("action_employee_id")
    private String actionEmployeeId;

    @TableField("action_employee_name")
    private String actionEmployeeName;

    @TableField("note")
    private String note;

    public RollCallEmployeeHistoryEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static RollCallEmployeeHistoryEntity create(
            RollCallType callType,
            String roomId,
            RollCallEmployeeEntity employee,
            RollCallStatus status,
            String note) {
        RollCallEmployeeHistoryEntity history = new RollCallEmployeeHistoryEntity();
        history.setActionEmployeeId(employee.getCalledEmployeeId());
        history.setRollCallId(employee.getRollCallId());
        history.setActionEmployeeName(employee.getCalledEmployeeName());
        history.setRollCallEmployeeId(employee.getId());
        history.setCalledEmployeeId(employee.getCalledEmployeeId());
        history.setCallType(callType);
        history.setStatus(status);
        history.setRoomId(roomId);
        history.setNote(note);

        return history;
    }

    public static RollCallEmployeeHistoryEntity create(
            RollCallType callType,
            RollCallEmployeeEntity employee,
                                                       RollCallStatus status,
                                                       String note) {
        RollCallEmployeeHistoryEntity history = new RollCallEmployeeHistoryEntity();
        history.setActionEmployeeId(BusinessConstants.DefaultEmptyValue);
        history.setActionEmployeeName(BusinessConstants.DefaultEmptyValue);
        history.setRollCallEmployeeId(employee.getId());
        history.setRollCallId(employee.getRollCallId());
        history.setCallType(callType);
        history.setCalledEmployeeId(employee.getCalledEmployeeId());
        history.setStatus(status);
        history.setNote(note);

        return history;
    }
}
