package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DispatchDataScopeType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;

@TableName(value = "rd_dispatch_data_scopes", autoResultMap = true)
@Data
public class RdDispatchDataScopeEntity extends EntityAbstract implements Aggregate {
    @TableId(value = "id")
    private String id;

    @TableField(value = "scope")
    private String scope;

    @TableField(value = "scope_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private DispatchDataScopeType scopeType;

    @TableField(value = "note")
    private String note;

    @TableField(value = "last_updated_time")
    private Timestamp lastUpdatedTime;
}
