package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.AnalyticsLogType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;
import java.time.Instant;

@TableName(value = "analytics_log")
@Data
public class AnalyticsLogEntity extends EntityAbstract implements Aggregate {
    @TableField(value = "dispatcher_id")
    private String dispatcherId;

    @TableField(value = "dispatcher_name")
    private String dispatcherName;

    @TableField(value = "dispatcher_type")
    private Integer dispatcherType;

    @TableField(value = "type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private AnalyticsLogType type;

    /**
     * 调度人所属公司
     */
    @TableField(value = "dispatcher_organization_id")
    private String dispatcherOrgId;

    @TableField(value = "created_time")
    private Timestamp createdTime;

    @TableField(value = "reference_number")
    private String referenceNumber;

    @TableField(value = "reference_name")
    private String referenceName;

    /**
     * 被调度数据所属的公司
     */
    @TableField(value = "reference_organization_id")
    private String refOrgId;

    @TableField(value = "params")
    private String params;

    /**
     * 这条记录产生的账单所属的公司
     */
    @TableField(value = "payer_organization_id")
    private String payerOrgId;

    public AnalyticsLogEntity(){
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static AnalyticsLogEntity create(String dispatcherId,
                                            String dispatcherName,
                                            Integer dispatcherType,
                                            AnalyticsLogType type,
                                            String dispatcherOrgId,
                                            String referenceNumber,
                                            String referenceName,
                                            String refOrgId,
                                            String params,
                                            String payerOrgId
                                            ){
        AnalyticsLogEntity entity = new AnalyticsLogEntity();
        entity.setDispatcherId(dispatcherId);
        entity.setDispatcherName(dispatcherName);
        entity.setDispatcherType(dispatcherType);
        entity.setType(type);
        entity.setDispatcherOrgId(dispatcherOrgId);
        entity.setReferenceNumber(referenceNumber);
        entity.setReferenceName(referenceName);
        entity.setRefOrgId(refOrgId);
        entity.setParams(params);
        entity.setPayerOrgId(payerOrgId);
        return entity;
    }

}
