package com.bcxin.tenant.open.domains.dtos;

import com.bcxin.tenant.open.infrastructures.enums.ContentType;
import lombok.Getter;

@Getter
public class SyncDbCheckQueryDTO {
    private final ContentType contentType;
    private final int pageIndex;
    private final int pageSize;

    private int getSkip() {
        if (pageIndex <= 1) {
            return 0;
        }

        return (pageIndex - 1) * pageSize;
    }

    public SyncDbCheckQueryDTO(ContentType contentType, int pageIndex, int pageSize) {
        this.contentType = contentType;
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }

    public static SyncDbCheckQueryDTO create(ContentType contentType, int pageIndex, int pageSize) {
        return new SyncDbCheckQueryDTO(contentType, pageIndex, pageSize);
    }
}
