package com.bcxin.tenant.open.domains.dtos;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Collection;

@Getter
@Setter(AccessLevel.PRIVATE)
public class DeviceBatchUpdateDTO  implements Serializable {
    private final Collection<DeviceItemDTO> items;

    public DeviceBatchUpdateDTO(Collection<DeviceItemDTO> items) {
        this.items = items;
    }

    @Getter
    public static class DeviceItemDTO {
        private final String deviceNo;
        private final String deviceUid;

        public DeviceItemDTO(String deviceNo, String deviceUid) {
            this.deviceNo = deviceNo;
            this.deviceUid = deviceUid;
        }

        public static DeviceItemDTO create(String deviceNo, String deviceUid){
            return new DeviceItemDTO(deviceNo,deviceUid);
        }
    }

    public static DeviceBatchUpdateDTO create(Collection<DeviceItemDTO> items) {
        return new DeviceBatchUpdateDTO(items);
    }
}
