package com.bcxin.tenant.open.domains.criterias;

import com.bcxin.tenant.open.infrastructures.criterias.CriteriaAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RollCallType;
import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;

@Getter
public class RollCallEmployeeGroupCriteria extends CriteriaAbstract {
    private final Long rollCallPlanId;
    private final String stationName;
    private final Collection<String> superviseDepartIds;
    private final Collection<String> stationTypes;
    private final String actionEmployeeName;
    private final Date beginDate;
    private final Date endDate;

    private final Collection<String> organizationIds;
    private final int calculatedCallTypeValue;

    private final String actionOrganizationId;

    public RollCallEmployeeGroupCriteria(
            int pageIndex,
            int pageSize,
            Long rollCallPlanId,
            Collection<String> organizationIds,
            String stationName, Collection<String> superviseDepartIds,
                                         Collection<String> stationTypes, String actionEmployeeName,
                                         Date beginDate, Date endDate, Collection<RollCallType> callTypes,
            String actionOrganizationId) {
        super(pageIndex, pageSize);
        this.organizationIds = organizationIds;
        this.stationName = stationName;

        this.superviseDepartIds = superviseDepartIds;
        if (CollectionUtils.isEmpty(stationTypes)) {
            this.stationTypes = stationTypes;
        } else {
            this.stationTypes = stationTypes.stream().map(ii -> String.format("\"%s\"", ii)).collect(Collectors.toList());
        }

        this.actionEmployeeName = actionEmployeeName;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.rollCallPlanId = rollCallPlanId;
        this.calculatedCallTypeValue = RollCallType.calculate(callTypes);
        this.actionOrganizationId=actionOrganizationId;
    }

    public static RollCallEmployeeGroupCriteria create(
            int pageIndex,
            int pageSize,
            Long rollCallPlanId,
            String[] organizationIds,
            String stationName, Collection<String> superviseDepartIds,
                                                       Collection<String> stationTypes, String actionEmployeeName,
                                                       Date beginDate, Date endDate, Collection<RollCallType> callTypes,
            String actionOrganizationId) {
        return new RollCallEmployeeGroupCriteria(
                pageIndex,pageSize,
                rollCallPlanId,
                organizationIds==null?null: Arrays.stream(organizationIds).toList(),
                stationName, superviseDepartIds, stationTypes, actionEmployeeName,
                beginDate, endDate, callTypes,actionOrganizationId);
    }
}
