package com.bcxin.tenant.open.domains.criterias;

import com.bcxin.tenant.open.infrastructures.criterias.CriteriaAbstract;
import lombok.Getter;

import java.util.Collection;

@Getter
public class RdSecurityStationRailCriteria  extends CriteriaAbstract {
    private final String stationId;
    private final Collection<String> superviseDepartIds;
    private final String keyWord;
    private final SearchModel searchModel;
    public RdSecurityStationRailCriteria(String stationId,Collection<String> superviseDepartIds,String keyWord,SearchModel searchModel) {
        this.stationId = stationId;
        this.superviseDepartIds = superviseDepartIds;
        this.keyWord = keyWord;
        this.searchModel = searchModel;
    }

    public static RdSecurityStationRailCriteria create(String stationId,Collection<String> superviseDepartIds,String keyWord,SearchModel searchModel) {
        return new RdSecurityStationRailCriteria(stationId,superviseDepartIds,keyWord,searchModel);
    }
    public static enum SearchModel {
        SecurityResource,
        Search,
        Station
    }
}
