package com.bcxin.tenant.open.domains.criterias;

import com.bcxin.tenant.open.infrastructures.criterias.CriteriaAbstract;
import com.bcxin.tenant.open.infrastructures.enums.AttendanceSearchModel;
import lombok.Getter;

@Getter
public class MyAttendanceCriteria extends CriteriaAbstract {
    private final String employeeId;

    private final AttendanceSearchModel searchModel;

    public MyAttendanceCriteria(AttendanceSearchModel searchModel,String employeeId,int pageIndex,int pageSize) {
        super(pageIndex, pageSize);
        this.searchModel = searchModel;
        this.employeeId = employeeId;
    }

    public static MyAttendanceCriteria create(AttendanceSearchModel searchModel, String employeeId,int pageIndex,int pageSize) {
        return new MyAttendanceCriteria(searchModel, employeeId,pageIndex,pageSize);
    }
}
