package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DispatchDataType;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.util.CollectionUtils;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.stream.Collectors;

@Document(language = SearchLanguage.CHINESE)
@Data
public class RdSyncStatusDocument  extends EntityAbstract {
    @Indexed
    private DispatchDataType dataType;
    @Indexed
    @Id
    private String topic;

    private long ts;
    private long totalSyncCount;
    private Timestamp lastSyncTime;
    private long lastOffset;

    /**
     * 限制20个
     */
    private String lastIds;


    public RdSyncStatusDocument() {
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    public void assignLastIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }

        lastIds = ids.stream().limit(20)
                .collect(Collectors.joining(";"));
        this.setTotalSyncCount(this.getTotalSyncCount() + ids.size());
    }
}
