package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.utils.SetUtil;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.GeoIndexed;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.Searchable;
import com.redis.om.spring.repository.query.SearchLanguage;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.geo.Point;
import org.springframework.util.StringUtils;

import java.sql.Date;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 临保项目信息
 */
@Document(language = SearchLanguage.CHINESE)
@Data
public class RdProjectDocument  extends EntityAbstract {

    @Id
    @Indexed
    private String id;

    private String name;

    private String companyName;

    /**
     * searchStream = searchStream.filter("*".concat(keyword).concat("*")); 采用这种方式实现模糊搜索
     */
    @Searchable(sortable = false, nostem = true, weight = 20.0)
    private String keyword;

    private String state;

    @Indexed
    @GeoIndexed
    private Point lonLat;

    private String organizationId;

    /**
     * 权限范围
     * 监管属性, 本企业, 内保单位, 内保主管单位
     */
    @Indexed
    private Set<String> scopePermissions;

    private String beginDate;

    private String endDate;

    //负责人
    private String principalId;
    //负责人姓名
    private String principalName;

    //负责人联系
    private String principalTelephone;

    //项目成员
    private int countOfMembers;

    //管理小组
    private int countOfTeams;

    //岗点数量
    private int countOfStations;

    public void updateWord(String... text) {
        if (text == null || text.length == 0) {
            this.setKeyword("");
        }
        String content =
                Arrays.stream(text).filter(ii -> StringUtils.hasLength(ii)).collect(Collectors.joining(" "));
        this.setKeyword(content);
    }

    public void rest() {
        this.setScopePermissions(new HashSet<>());
    }

    public void addScopePermissions(String... scopeIds) {
        this.setScopePermissions(SetUtil.merge(this.getScopePermissions(), scopeIds));
    }

    public static RdProjectDocument create(String id,String name) {
        RdProjectDocument document = new RdProjectDocument();
        document.setId(id);
        document.setName(name);

        return document;
    }
}
