package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DispatchDataScopeType;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

@Document(language = SearchLanguage.CHINESE)
@Data
public class RdDispatchDataScopeDocument  extends EntityAbstract {
    @Id
    @Indexed
    private String id;
    @Indexed
    private Set<String> scopes;
    private DispatchDataScopeType scopeType;

    public void assignScopes(String... scopes) {
        if (scopes == null || scopes.length == 0) {
            this.setScopes(new HashSet<>());
        } else {
            this.setScopes(
                    Arrays.stream(scopes).filter(ii -> StringUtils.hasLength(ii))
                            .collect(Collectors.toSet())
            );
        }
    }

    public static RdDispatchDataScopeDocument create(String id,DispatchDataScopeType scopeType)
    {
        RdDispatchDataScopeDocument document = new RdDispatchDataScopeDocument();
        document.setId(id);
        document.setScopeType(scopeType);
        return document;
    }
}
