package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.constants.BusinessConstants;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DeviceStatus;
import com.bcxin.tenant.open.infrastructures.enums.DeviceType;
import com.bcxin.tenant.open.infrastructures.utils.SetUtil;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.GeoIndexed;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.Searchable;
import com.redis.om.spring.repository.query.SearchLanguage;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.geo.Point;
import org.springframework.util.StringUtils;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 智能设备信息
 */
@Document(language = SearchLanguage.CHINESE)
@Data
public class RdDeviceDocument  extends EntityAbstract implements Aggregate {

    @Id
    @Indexed
    private String id;

    @Searchable(sortable = false, nostem = true, weight = 20.0)
    private String keyword;

    @Indexed

    private String dispatchNo;

    private String deviceUid;

    private String deviceNo;

    private String deviceModel;

    @Indexed
    private String organizationId;

    private String organizationName;

    @Indexed
    private String securityStationId;

    private String securityStationName;

    private DeviceType deviceType;

    private DeviceStatus deviceStatus;

    @Indexed
    private Boolean dispatchable;

    /**
     * 所属内保单位
     */
    private String proprietorCompanyName;

    private String proprietorCompanyId;

    /**
     * 相关的内保单位
     *
     * @param companyId
     * @param companyName
     */
    public void assignProprietor(String companyId, String companyName) {
        this.setProprietorCompanyId(companyId);
        this.setProprietorCompanyName(companyName);
    }

    public void changeStatus(DeviceStatus deviceStatus) {
        this.setDeviceStatus(deviceStatus);
        this.setDispatchable(deviceStatus == DeviceStatus.Online);
    }

    @Indexed
    @GeoIndexed
    private Point lonLat;

    /**
     * 资源类型: 保安,人口
     */
    @Indexed
    private Set<String> resourceTypes;

    private Timestamp lastSyncTime;

    @Indexed
    private Set<String> scopePermissions;

    public static RdDeviceDocument create(String id) {
        RdDeviceDocument document = new RdDeviceDocument();
        document.setId(id);

        document.setLonLat(new Point(BusinessConstants.INVALID_LON_LAT, BusinessConstants.INVALID_LON_LAT));
        return document;
    }

    public void updateWord(String... text) {
        if (text == null || text.length == 0) {
            this.setKeyword("");
        }
        String content =
                Arrays.stream(text).filter(ii -> StringUtils.hasLength(ii)).collect(Collectors.joining(" "));
        this.setKeyword(content);
    }

    public void addResourceTypes(String... resourceTypes) {
        this.setResourceTypes(SetUtil.merge(this.getResourceTypes(), resourceTypes));
    }

    public void addScopePermissions(String... scopeIds) {
        this.setScopePermissions(SetUtil.merge(this.getScopePermissions(), scopeIds));
    }

    public void removeBusinessScopePermissions(String... scopeIds) {
        this.setScopePermissions(SetUtil.remove(this.getScopePermissions(), scopeIds));
        this.setScopePermissions(SetUtil.merge(this.getScopePermissions(), this.getOrganizationId()));
    }

    public void changeLonLat(Point lonLat) {
        this.setLonLat(lonLat);
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    public void rest() {
        this.setScopePermissions(new HashSet<>());
        this.setResourceTypes(new HashSet<>());
    }
}
