package com.bcxin.tenant.open.document.domains.documents;
import com.bcxin.tenant.open.infrastructures.constants.BusinessConstants;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.CompanyStatus;
import com.bcxin.tenant.open.infrastructures.utils.SetUtil;
import com.redis.om.spring.annotations.*;
import com.redis.om.spring.repository.query.SearchLanguage;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.geo.Point;
import org.springframework.util.StringUtils;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;


/**
 * 调度的企业信息
 */
@Document(language = SearchLanguage.CHINESE)
@Data
public class RdCompanyDocument extends EntityAbstract {
    @Indexed
    private String id;

    @Indexed
    private String name;

    @Searchable(sortable = false, nostem = true, weight = 20.0)
    private String keyword;

    private String legal;

    private String legalTelephone;

    @Indexed
    private String institutional;

    @Indexed
    private String registerAddress;

    @Indexed
    private String businessAddress;

    private Long countOfActivityStation;

    private Long countOfSecurityMan;

    private Long countOfMan;

    private String serviceScope;

    @Indexed
    @GeoIndexed
    private Point lonLat;

    @Id
    @Indexed
    private String organizationId;

    /**
     * 剩余的联动值数量
     */
    @Indexed
    private Long points;

    /**
     * 调度台数量
     */
    @Indexed
    private int countOfDesk;

    /**
     * 内保项目数量
     */
    private long countOfTemporaryProject;

    private CompanyStatus status;

    private Timestamp lastUpdatedTime;

    @Indexed
    private String superviseDepartId;

    private String superviseDepartName;

    private String industry;

    /**
     * 使用Boolean的话; false的过滤无法使用
     */
    @Indexed
    private int hasLonLatFlag;

    /**
     * 权限范围
     * 监管属性, 本企业, 内保单位, 内保主管单位
     */
    @Indexed
    private Set<String> scopePermissions;

    /**
     * 资源类型: 保安公司,群防群治,内保单位,临保业务
     */
    @Indexed
    private Set<String> resourceTypes;

    @Indexed
    @TagIndexed
    private Set<String> followedDeviceNos;

    /**
     * 监管区域编码
     */
    private String superviseRegionCode;

    public RdCompanyDocument() {
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void addScopePermissions(String... scopeIds) {
        this.setScopePermissions(SetUtil.merge(this.getScopePermissions(), scopeIds));
    }

    public void addResourceTypes(String... resourceTypes) {
        this.setResourceTypes(SetUtil.merge(this.getResourceTypes(), resourceTypes));
    }

    public boolean addFollowedDeviceNo(String deviceNo) {
        this.setFollowedDeviceNos(SetUtil.merge(this.getFollowedDeviceNos(), deviceNo));

        return true;
    }

    public boolean removeFollowedDeviceNo(String deviceNo) {
        this.setFollowedDeviceNos(SetUtil.remove(this.getFollowedDeviceNos(), deviceNo));

        return true;
    }

    public void updateWord(String... text) {
        if (text == null || text.length == 0) {
            this.setKeyword("");
        }
        String content =
                Arrays.stream(text).filter(ii -> StringUtils.hasLength(ii)).collect(Collectors.joining(" "));

        this.setKeyword(content);
    }

    public void rest() {
        this.setSuperviseDepartId(BusinessConstants.DefaultEmptyValue);
        this.setScopePermissions(new HashSet<>());
        this.setResourceTypes(new HashSet<>());
    }

    /**
     * 更新临保项目数量
     * @param count
     */
    public void updateCountOfProject(long count){
        this.setCountOfTemporaryProject(count);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }
}