package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import lombok.Data;
import org.springframework.data.annotation.Id;

/**
 * 社区民警, 人口
 */
@Document(language = SearchLanguage.CHINESE)
@Data
public class RdCommunityUserDocument  extends EntityAbstract implements Aggregate {
    @Id
    @Indexed
    private String id;

    @Indexed
    private String tenantUserId;

    @Indexed
    private String superviseDepartId;

    private String superviseDepartName;


    public static RdCommunityUserDocument create(String id,
                                                 String tenantUserId,
                                                 String superviseDepartId,
                                                 String superviseDepartName) {
        RdCommunityUserDocument document = new RdCommunityUserDocument();
        document.setId(id);
        document.setTenantUserId(tenantUserId);
        document.setSuperviseDepartId(superviseDepartId);
        document.setSuperviseDepartName(superviseDepartName);

        return document;
    }
}
