package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.InstantDataType;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import lombok.Data;
import org.springframework.data.annotation.Id;

@Document(language = SearchLanguage.CHINESE,timeToLive = 5*60)
@Data
public class InstantActivityDataDocument  extends EntityAbstract {
    @Indexed
    @Id
    public String id;

    private InstantDataType dataType;

    /**
     * 业务表的Id; 比如: RollCallEmployee的Id的值
     */
    private String businessValue;

    private String referenceNumber;

    public static InstantActivityDataDocument create(InstantDataType dataType, String referenceNumber, String employeeId, String businessValue) {
        InstantActivityDataDocument document = new InstantActivityDataDocument();
        document.setId(generateId(referenceNumber, employeeId));
        document.setDataType(dataType);
        document.setBusinessValue(businessValue);
        document.setReferenceNumber(referenceNumber);

        return document;
    }

    public static String generateId(String referenceNumber, String employeeId) {
        return String.format("%s_%s", referenceNumber, employeeId);
    }
}
