package com.bcxin.tenant.open.document.domains.components;

import com.bcxin.tenant.open.document.domains.documents.RdDispatchDataScopeDocument;
import com.bcxin.tenant.open.document.domains.documents.RdDispatchDataScopeDocument$;
import com.bcxin.tenant.open.document.domains.dtos.SearchSpecialPermissionScopeDTO;
import com.bcxin.tenant.open.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.open.infrastructures.utils.BusinessUtil;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.SearchStream;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.stream.Collectors;

@Component
public class SearchSpecialPermissionScopeComponentImpl implements SearchSpecialPermissionScopeComponent {
    private final EntityStream entityStream;

    public SearchSpecialPermissionScopeComponentImpl(EntityStream entityStream) {
        this.entityStream = entityStream;
    }

    @Override
    public SearchSpecialPermissionScopeDTO get(TenantEmployeeContext.TenantUserModel userModel) {
        if (!BusinessUtil.isProprietor(userModel.getOrgInstitutional())) {
            return SearchSpecialPermissionScopeDTO.createEmpty();
        }

        SearchStream<RdDispatchDataScopeDocument> scopeDocumentSearchStream =
                this.entityStream.of(RdDispatchDataScopeDocument.class);
        scopeDocumentSearchStream = scopeDocumentSearchStream.filter(RdDispatchDataScopeDocument$.SCOPES.in(
                userModel.getOrganizationId()
        ));


        Collection<RdDispatchDataScopeDocument> documents =
                scopeDocumentSearchStream.collect(Collectors.toList());

        Collection<String> scopeIds =
                documents.stream().map(ii -> ii.getId()).distinct().collect(Collectors.toList());

        return SearchSpecialPermissionScopeDTO.create(true, scopeIds);
    }
}
