package com.bcxin.tenant.open.backend.tasks.rings;

import com.bcxin.tenant.open.backend.tasks.rings.components.ClearingEventHandler;
import com.bcxin.tenant.open.backend.tasks.rings.components.ProcessingEventHandler;
import com.bcxin.tenant.open.backend.tasks.rings.components.RingBufferProducer;
import com.bcxin.tenant.open.infrastructures.events.ObjectEvent;
import com.bcxin.tenant.open.jdks.CompanyWriterRpcProvider;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.util.DaemonThreadFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RingBufferConfig {

    @Bean
    public ProcessingEventHandler cacheEventHandler(CompanyWriterRpcProvider companyWriterRpcProvider) {
        return new ProcessingEventHandler(companyWriterRpcProvider);
    }

    @Bean
    public RingBufferProducer ringBufferProducer(
            ProcessingEventHandler processingEventHandler) {
        final int BUFFER_SIZE = 1024 * 1024;
        Disruptor<ObjectEvent<?>> disruptor = new Disruptor<>(
                () -> new ObjectEvent<>(), BUFFER_SIZE, DaemonThreadFactory.INSTANCE);
        disruptor
                .handleEventsWith(processingEventHandler)
                .then(new ClearingEventHandler());

        disruptor.start();

        RingBuffer<ObjectEvent<?>> ringBuffer = disruptor.getRingBuffer();
        return new RingBufferProducer(ringBuffer);
    }
}
