package com.bcxin.tenant.open.backend.tasks.dtos;

import lombok.Data;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;

@Data
public class TimeCachedDataWrapper<T>{
    private Date expiredTime;
    private T data;

    public boolean isExpired() {
        return expiredTime.before(Timestamp.from(Instant.now()));
    }


    public static <T> TimeCachedDataWrapper<T> create(Date expiredTime,T data) {
        TimeCachedDataWrapper wrapper = new TimeCachedDataWrapper();
        wrapper.setExpiredTime(expiredTime);
        wrapper.setData(data);

        return wrapper;
    }
}
