package com.bcxin.tenant.open.backend.tasks.configs;

import com.alibaba.fastjson2.JSONObject;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.constants.KafkaConstants;
import com.bcxin.tenant.open.jdks.OrgPurseTransactionRpcProvider;
import com.bcxin.tenant.open.jdks.requests.OrgPurseTransactionBillRequest;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

@Component
public class KafkaComponent_MonthlyBillRelated {
    private final Logger logger = LoggerFactory.getLogger(KafkaComponent_MonthlyBillRelated.class);
    private final OrgPurseTransactionRpcProvider orgPurseTransactionRpcProvider;
    private JsonProvider jsonProvider;

    public KafkaComponent_MonthlyBillRelated(OrgPurseTransactionRpcProvider orgPurseTransactionRpcProvider, JsonProvider jsonProvider) {
        this.orgPurseTransactionRpcProvider = orgPurseTransactionRpcProvider;
        this.jsonProvider = jsonProvider;
    }

    @KafkaListener(id = "${spring.kafka.consumer.group-id}-bill",
            topics = {KafkaConstants.TOPIC_DISPATCH_TLK_ORG_PURSE},
            groupId = "${spring.kafka.consumer.group-id}-bill-related")
    public void ackOrgPurseForBillsListener(List<ConsumerRecord<String, String>> records, Acknowledgment acknowledgment) {
        if (records.isEmpty()) {
            logger.warn("无效企业钱包订阅数据");
            return;
        }
        boolean allowed2CommitAtFinial = true;
        try {
            List<String> orgIds = records.stream().map(ix -> {
                JSONObject recordObject = jsonProvider.toObject(JSONObject.class, ix.value());
                JSONObject before = recordObject.getJSONObject("before");
                JSONObject after = recordObject.getJSONObject("after");
                /**
                 * 只考虑充值的时候(before < after)，触发账单扣费
                 */
                int beforePoint = before == null ? 0 : before.getInteger("ITEM_POINTS") == null ? 0 : before.getInteger("ITEM_POINTS");
                int afterPoint = after == null ? 0 : after.getInteger("ITEM_POINTS") == null ? 0 : after.getInteger("ITEM_POINTS");
                if (after != null && afterPoint > 0 && beforePoint < afterPoint) {
                    return after.getString("ITEM_ORGANIZATION_ID");
                } else {
                    return null;
                }
            }).filter(ii -> ii != null).distinct().collect(Collectors.toList());

            if (!orgIds.isEmpty()) {
                orgPurseTransactionRpcProvider.chargeBills(OrgPurseTransactionBillRequest.create(orgIds));
            }
        } catch (Exception e) {
            logger.error("月度账单监听器消费企业钱包消息时发生异常", e);
            allowed2CommitAtFinial = false;
        } finally {
            if (allowed2CommitAtFinial) {
                acknowledgment.acknowledge();
            }
        }
    }
}
