package com.bcxin.tenant.open.backend.tasks.configs;

import com.bcxin.tenant.open.backend.tasks.properties.RtcDeviceProperty;
import com.bcxin.tenant.open.dubbo.common.configs.DubboConfigProperty;
import com.bcxin.tenant.open.jdks.*;
import org.apache.dubbo.common.constants.ClusterRules;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.spring.context.annotation.EnableDubbo;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@EnableDubbo(scanBasePackages = "com.bcxin.tenant.open.backend.tasks.impls")
@ComponentScan(basePackages = "com.bcxin.tenant")
@Configuration
@EnableConfigurationProperties(RtcDeviceProperty.class)
public class DubboConfig {
    @DubboReference
    private final EmployeeWriterRpcProvider employeeWriterRpcProvider;
    @DubboReference
    private final CompanyWriterRpcProvider companyWriterRpcProvider;
    @DubboReference
    private final SecurityStationWriterRpcProvider securityStationWriterRpcProvider;

    @DubboReference
    private final RdSyncRpcWriterProvider rdSyncRpcWriterProvider;

    @DubboReference(async = false)
    private final TencentCallbackLogRpcProvider tencentCallbackLogRpcProvider;
    @DubboReference
    private final EmployeeReaderRpcProvider employeeReaderRpcProvider;
    @DubboReference
    private final SecurityStationReaderRpcProvider securityStationReaderRpcProvider;

    @DubboReference
    private final SocketPublishRpcProvider socketPublishRpcProvider;

    @DubboReference
    private final PoliceIncidentsRpcProvider policeIncidentsRpcProvider;

    @DubboReference
    private final RdSecurityStationRailWriterRpcProvider rdSecurityStationRailWriterRpcProvider;

    @DubboReference
    private final RoomRpcProvider roomRpcProvider;

    @DubboReference
    private final CompanyReaderRpcProvider companyReaderRpcProvider;

    @DubboReference
    private final DailyBillRpcProvider dailyBillRpcProvider;

    @DubboReference
    private final MonthlyBillRpcProvider monthlyBillRpcProvider;
    @DubboReference
    private final OrgPurseTransactionRpcProvider orgPurseTransactionRpcProvider;

    @DubboReference
    private final CommunityUserWriterRpcProvider communityUserWriterRpcProvider;

    @DubboReference
    private final AttendanceRpcProvider attendanceRpcProvider;

    @DubboReference
    private final DispatchDataScopeRpcProvider dispatchDataScopeRpcProvider;

     @DubboReference
    private final ExamSiteWriterRpcProvider examSiteRpcProvider;

    @DubboReference
    private final ExamRoomRpcProvider examRoomRpcProvider;

    @DubboReference
    private final SystemExamInfoRpcProvider systemExamInfoRpcProvider;

    @DubboReference
    private final RollCallWriterRpcProvider rollCallWriterRpcProvider;

    @DubboReference
    private final RollCallPlanRpcProvider rollCallPlanRpcProvider;

    @DubboReference
    private final ProjectWriterRpcProvider projectWriterRpcProvider;

    @DubboReference
    private final DeviceReaderRpcProvider deviceReaderRpcProvider;

    @DubboReference
    private final DeviceWriterRpcProvider deviceWriterRpcProvider;

    @DubboReference(cluster = ClusterRules.BROADCAST)
    private final HotCacheRpcProvider hotCacheRpcProvider;

    @DubboReference
    private final ThirdDeviceRpcProvider thirdDeviceRpcProvider;

    @DubboReference
    private final UserWriterRpcProvider userWriterRpcProvider;

    public DubboConfig(EmployeeWriterRpcProvider employeeWriterRpcProvider,
                       CompanyWriterRpcProvider companyWriterRpcProvider,
                       SecurityStationWriterRpcProvider securityStationWriterRpcProvider,
                       RdSyncRpcWriterProvider rdSyncRpcWriterProvider,
                       TencentCallbackLogRpcProvider tencentCallbackLogRpcProvider,
                       EmployeeReaderRpcProvider employeeReaderRpcProvider,
                       SecurityStationReaderRpcProvider securityStationReaderRpcProvider,
                       SocketPublishRpcProvider socketPublishRpcProvider,
                       PoliceIncidentsRpcProvider policeIncidentsRpcProvider,
                       RdSecurityStationRailWriterRpcProvider rdSecurityStationRailWriterRpcProvider,
                       RoomRpcProvider roomRpcProvider,
                       CompanyReaderRpcProvider companyReaderRpcProvider,
                       DailyBillRpcProvider dailyBillRpcProvider,
                       MonthlyBillRpcProvider monthlyBillRpcProvider,
                       OrgPurseTransactionRpcProvider orgPurseTransactionRpcProvider,
                       CommunityUserWriterRpcProvider communityUserWriterRpcProvider,
                       AttendanceRpcProvider attendanceRpcProvider,
                       DispatchDataScopeRpcProvider dispatchDataScopeRpcProvider,
                       ExamSiteWriterRpcProvider examSiteRpcProvider,
                       ExamRoomRpcProvider examRoomRpcProvider,
                       SystemExamInfoRpcProvider systemExamInfoRpcProvider,
                       RollCallWriterRpcProvider rollCallWriterRpcProvider, RollCallPlanRpcProvider rollCallPlanRpcProvider,
                       DeviceReaderRpcProvider deviceReaderRpcProvider, DeviceWriterRpcProvider deviceWriterRpcProvider,
                       ProjectWriterRpcProvider projectWriterRpcProvider,
                       HotCacheRpcProvider hotCacheRpcProvider, ThirdDeviceRpcProvider thirdDeviceRpcProvider, UserWriterRpcProvider userWriterRpcProvider) {
        this.employeeWriterRpcProvider = employeeWriterRpcProvider;
        this.companyWriterRpcProvider = companyWriterRpcProvider;
        this.securityStationWriterRpcProvider = securityStationWriterRpcProvider;
        this.rdSyncRpcWriterProvider = rdSyncRpcWriterProvider;
        this.tencentCallbackLogRpcProvider = tencentCallbackLogRpcProvider;
        this.employeeReaderRpcProvider = employeeReaderRpcProvider;
        this.securityStationReaderRpcProvider = securityStationReaderRpcProvider;
        this.socketPublishRpcProvider = socketPublishRpcProvider;
        this.policeIncidentsRpcProvider = policeIncidentsRpcProvider;
        this.rdSecurityStationRailWriterRpcProvider = rdSecurityStationRailWriterRpcProvider;
        this.roomRpcProvider = roomRpcProvider;
        this.companyReaderRpcProvider = companyReaderRpcProvider;
        this.dailyBillRpcProvider = dailyBillRpcProvider;
        this.monthlyBillRpcProvider = monthlyBillRpcProvider;
        this.orgPurseTransactionRpcProvider = orgPurseTransactionRpcProvider;
        this.communityUserWriterRpcProvider = communityUserWriterRpcProvider;
        this.attendanceRpcProvider = attendanceRpcProvider;
        this.dispatchDataScopeRpcProvider = dispatchDataScopeRpcProvider;
        this.examSiteRpcProvider = examSiteRpcProvider;
        this.examRoomRpcProvider = examRoomRpcProvider;
        this.systemExamInfoRpcProvider = systemExamInfoRpcProvider;
        this.rollCallWriterRpcProvider = rollCallWriterRpcProvider;
        this.rollCallPlanRpcProvider = rollCallPlanRpcProvider;
        this.projectWriterRpcProvider = projectWriterRpcProvider;
        this.deviceReaderRpcProvider = deviceReaderRpcProvider;
        this.deviceWriterRpcProvider = deviceWriterRpcProvider;
        this.hotCacheRpcProvider = hotCacheRpcProvider;
        this.thirdDeviceRpcProvider = thirdDeviceRpcProvider;
        this.userWriterRpcProvider = userWriterRpcProvider;
    }

    @Bean
    public ConsumerConfig registryConfig(DubboConfigProperty property) {
        ConsumerConfig config = new ConsumerConfig();
        config.setCheck(false);
        /**
         * 不过期
         */
        config.setTimeout(120 * 1000);
        /**
         * 禁用重试
         */
        config.setRetries(0);
        config.setVersion(property.getVersion());
        config.setCheck(false);

        return config;
    }
}
