package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Schema(name = "StationStatisticsResponse",title = "按照驻勤点类型进行统计返回")
@Getter
public class StationStatisticsResponse extends ResponseAbstract {
    @Schema(name = "stationTypeCode", title = "驻勤点类型")
    private final String stationTypeCode;
    @Schema(name = "countOfStations", title = "驻勤点数量")
    private final int countOfStations;
    @Schema(name = "countOfSecurityMen", title = "驻勤人员数量")
    private final int countOfSecurityMen;

    public StationStatisticsResponse(String stationTypeCode, int countOfStations, int countOfSecurityMen) {
        this.stationTypeCode = stationTypeCode;
        this.countOfStations = countOfStations;
        this.countOfSecurityMen = countOfSecurityMen;
    }

    public static StationStatisticsResponse create(String stationTypeCode, int countOfStations, int countOfSecurityMen) {
        return new StationStatisticsResponse(stationTypeCode, countOfStations, countOfSecurityMen);
    }
}
