package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.constants.BusinessConstants;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventCategory;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventLevel;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventStatus;
import com.bcxin.tenant.open.infrastructures.utils.PoliceEventCategoryUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

@Schema(name = "PoliceIncidentOverviewResponse",title = "PoliceIncidentOverviewResponse 警情上报详情信息")
@Getter
public class PoliceIncidentOverviewResponse extends ResponseAbstract {
    @Schema(name = "id", title = "id")
    private final String id;

    @Schema(name = "tenantUserId", title = "人员ID")
    private final String tenantUserId;

    @Schema(name = "tenantUserName", title = "姓名")
    private final String tenantUserName;

    @Schema(name = "idNumber", title = "身份证号")
    private final String idNumber;

    @Schema(name = "tenantEmployeeId", title = "雇员ID")
    private final String tenantEmployeeId;

    @Schema(name = "organizationId", title = "企业ID")
    private final String organizationId;

    @Schema(name = "organizationName", title = "企业名称")
    private final String organizationName;
    @Schema(name = "securityStationId", title = "驻勤点ID")
    private final String securityStationId;

    @Schema(name = "securityStationName", title = "驻勤点名称")
    private final String securityStationName;

    @Schema(name = "securityStationAddress", title = "驻勤点地址")
    private final String securityStationAddress;

    @Schema(name = "superviseDepartId", title = "监管机构ID")
    private final String superviseDepartId;

    @Schema(name = "superviseDepartName", title = "监管机构名称")
    private final String superviseDepartName;

    @Schema(name = "code", title = "事件编码")
    private final String code;
    @Schema(name = "name", title = "事件标题/线索标题")
    private final String name;
    @Schema(name = "empName", title = "雇员名称")
    private final String empName;

    @Schema(name = "sceneUrl", title = "现场图片")
    private final String sceneUrl;

    @Schema(name = "contact", title = "联系电话")
    private final String contact;

    @Schema(name = "policeEventStatus", title = "处理状态：None 待处理，Pending 处理中，Over 已处理")
    private final String policeEventStatus;

    @Schema(name = "policeEventLevel", title = "事件级别：Comon 一般，More 较大，Great 重大，Greats 特别重大")
    private final String policeEventLevel;

    @Schema(name = "address", title = "事件地址/警情上报的地址")
    private final String address;

    @Schema(name = "reason", title = "事件起因/线索内容")
    private final String reason;

    @Schema(name = "policeEventType", title = "事件类型; 根据/json/policeIncident-meta.json取到的值进行显示")
    private final String policeEventType;

    @Schema(name = "category", title = "事件类别")
    private final PoliceEventCategory category;

    @Schema(name = "latitude", title = "纬度 y")
    private final double latitude;

    @Schema(name = "longitude", title = "经度 x")
    private final double longitude;

    @Schema(name = "actionTaken", title = "已采取措施/sos的处理说明")
    private final String actionTaken;

    @Schema(name = "actionTendency", title = "发展趋势")
    private final String actionTendency;

    @Schema(name = "processedSuggestion", title = "公安建议")
    private final String processedSuggestion;

    @Schema(name = "processedLocaleGuidance", title = "现场指导意见")
    private final String processedLocaleGuidance;

    @Schema(name = "processedUserId", title = "处理人(公安)id")
    private final String processedUserId;

    @Schema(name = "processedUserName", title = "处理人(公安)姓名")
    private final String processedUserName;

    @Schema(name = "processedTime", title = "处理时间")
    private final String processedTime;

    @Schema(name = "createdTime", title = "创建（报案）时间/Sos的操作时间/上报时间")
    private final String createdTime;

    @Schema(name = "description", title = "事件说明")
    private final String description;

    @Schema(name = "location", title = "报警地址")
    private final String location;

    @Schema(name = "projectId", title = "项目Id")
    private final String projectId;

    @Schema(name = "projectName", title = "项目名称")
    private final String projectName;

    @Schema(name = "items", title = "扩展字段: items.regionName表示所属区域; items.requirement表示诉求/要求; items.eventDate表示线索日期;items.scale表示规模;")
    private Map<String, Object> items;

    @Schema(name = "points", title = "积分")
    private final int points;


    public PoliceIncidentOverviewResponse(
            String id,
            PoliceEventCategory category,
            String tenantUserId, String tenantUserName,
            String tenantEmployeeId, String idNumber,
            String organizationId, String organizationName,
            String securityStationId, String securityStationName,
            String superviseDepartId, String superviseDepartName,
            String code, String name, String empName,
            String sceneUrl, String contact, PoliceEventStatus eventStatus,
            PoliceEventLevel eventLevel, String address, String reason, int eventType,
            double latitude, double longitude, String actionTaken, String actionTendency,
            String processedSuggestion, String processedLocaleGuidance, String processedUserId,
            String processedUserName, Timestamp processedTime, Timestamp createdTime,
            String securityStationAddress, String description,
            String location,
            String projectId,
            String projectName,
            Map<String,Object> items,
            int points) {
        this.id = id;
        this.category = category;
        this.tenantUserId = tenantUserId;
        this.tenantUserName = tenantUserName;
        this.tenantEmployeeId = tenantEmployeeId;
        this.organizationId = organizationId;
        this.organizationName = organizationName;
        this.securityStationId = securityStationId;
        this.superviseDepartId = superviseDepartId;

        this.idNumber = idNumber;
        this.securityStationAddress = securityStationAddress;
        this.items = items;

        if (BusinessConstants.DefaultEmptyValue.equals(superviseDepartName)) {
            this.superviseDepartName = "";
        } else {
            this.superviseDepartName = superviseDepartName;
        }
        if (BusinessConstants.DefaultEmptyValue.equals(securityStationName)) {
            this.securityStationName = "";
        } else {
            this.securityStationName = securityStationName;
        }
        this.code = code;
        this.name = name;
        this.empName = empName;
        this.sceneUrl = sceneUrl;
        this.contact = contact;
        this.policeEventStatus = eventStatus.getTypeName();
        this.policeEventLevel = eventLevel.getTypeName();
        this.address = address;
        this.reason = reason;
        this.policeEventType = PoliceEventCategoryUtils.getEventTypeName(category, eventType);
        this.latitude = latitude;
        this.longitude = longitude;
        this.actionTaken = actionTaken;
        this.actionTendency = actionTendency;
        this.processedSuggestion = processedSuggestion;
        this.processedLocaleGuidance = processedLocaleGuidance;
        this.processedUserId = processedUserId;
        this.processedUserName = processedUserName;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (processedTime != null) {
            this.processedTime = dateFormat.format(processedTime);
        } else {
            this.processedTime = null;
        }

        this.createdTime = dateFormat.format(createdTime);
        this.description = description;
        this.location = location;
        this.projectId = projectId;
        this.projectName = projectName;
        this.points = points;
    }

    public static PoliceIncidentOverviewResponse create(
            String id,
            PoliceEventCategory category,
            String tenantUserId, String tenantUserName,
            String tenantEmployeeId, String idNumber,
            String organizationId, String organizationName,
            String securityStationId, String securityStationName,
            String superviseDepartId, String superviseDepartName,
            String code, String name, String empName,
            String sceneUrl, String contact, PoliceEventStatus eventStatus,
            PoliceEventLevel eventLevel, String address, String reason, int eventType,
            double latitude, double longitude, String actionTaken, String actionTendency,
            String processedSuggestion, String processedLocaleGuidance, String processedUserId,
            String processedUserName, Timestamp processedTime, Timestamp createdTime,
            String securityStationAddress,String description,
            String location,
            String projectId,
            String projectName,
            Map<String,Object> items,
            int points) {
        return new PoliceIncidentOverviewResponse(
                id, category, tenantUserId, tenantUserName,
                tenantEmployeeId, idNumber, organizationId, organizationName,
                securityStationId, securityStationName, superviseDepartId, superviseDepartName,
                code, name, empName, sceneUrl, contact, eventStatus, eventLevel,
                address, reason, eventType,
                latitude, longitude, actionTaken, actionTendency, processedSuggestion,
                processedLocaleGuidance, processedUserId, processedUserName,
                processedTime, createdTime, securityStationAddress, description,
                location, projectId, projectName,
                items,points);
    }
}
