package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.ProjectStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Date;

@Schema(name = "ProjectAdvanceSearchRequest",title = "业务管理-临保项目搜索")
@Data
public class ProjectAdvanceSearchRequest extends SearchDeskRequestAbstract {
    @Schema(name = "name", title = "项目名称")
    private String name;

    @Schema(name = "type", title = "项目类型")
    private String type;

    @Schema(name = "status", title = "项目状态")
    private ProjectStatus status;

    @Schema(name = "beginDate", title = "开始日期")
    private Date beginDate;

    @Schema(name = "endDate", title = "结束日期")
    private Date endDate;
}
