package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.PoliceEventCategory;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventLevel;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.sql.Date;
import java.util.Map;

@Schema(name = "CreatePoliceIncidentsRequest",title = "CreatePoliceIncidentsRequest 新增警情上报")
@Data
public class CreatePoliceIncidentsRequest extends RequestAbstract {

    @Schema(name = "category", title = "事件类别;/identity/{accountType}/auto-login 中的regionCode为1405则提交的时候直接固定提交QT且不显示")
    private PoliceEventCategory category;

    @Schema(name = "contact", title = "联系电话")
    private String contact;

    @Schema(name = "sceneUrl", title = "现场图片")
    private String sceneUrl;

    @Schema(name = "policeEventLevel", title = "事件级别/线索级别：Comon 一般，More 较大，Great 重大，Greats 特别重大")
    private PoliceEventLevel policeEventLevel;

    @Schema(name = "policeEventType", title = "事件类型:根据category取得不同的值; 相关的值参考: /json/policeIncident-meta.json; 当category=QT的时候; 取0")
    private int policeEventType;

    @Schema(name = "address", title = "事件地址")
    private String address;

    @Schema(name = "name", title = "线索标题")
    private String name;

    @Schema(name = "reason", title = "事件起因/线索内容")
    private String reason;

    @Schema(name = "actionTaken", title = "已采取措施; 无此字段可以不填")
    private String actionTaken;

    @Schema(name = "actionTendency", title = "发展趋势; 无此字段可以不填")
    private String actionTendency;

    @Schema(name = "latitude", title = "纬度 y")
    private double latitude;

    @Schema(name = "longitude", title = "经度 x")
    private double longitude;

    @Schema(name = "location", title = "报警地址/线索地址")
    private String location;

    @Schema(name = "description", title = "事件说明/备注")
    private String description;

    @Schema(name = "items", title = "扩展字段: items.regionName表示所属区域; items.requirement表示诉求/要求; items.eventDate表示线索日期;items.scale表示规模;items.desc表示描述;items.company表示单位名称;")
    private Map<String, Object> items;
}
