import { createRouter, createWebHistory } from "vue-router";
import { ElMessageBox } from 'element-plus';
import request from "../utils/request";

const routes = [
  {
    path: '/',
    redirect: '/shop'
  },

  {
    path: '/autologin',
    component: () => import('../views/autoLogin.vue')
  },

  {
    path: '/shop',
    component: () => import('../views/shop/index.vue'),
    children: [
      {
        path: '',
        component: () => import('../views/shop/home.vue')
      },

      {
        path: 'goodsList',
        component: () => import('../views/shop/goodsList.vue')
      },

      {
        path: 'searchResult',
        component: () => import('../views/shop/searchResult.vue')
      },

      {
        path: 'toBeLaunched',
        component: () => import('../views/shop/toBeLaunched.vue')
      }
    ]
  },

  {
    path: '/userCenter',
    component: () => import('../views/userCenter/index.vue'),
    children: [
      {
        path: 'orderManage',
        component: () => import('../views/userCenter/orderManage.vue')
      },

      {
        path: 'onlineService',
        component: () => import('../views/userCenter/onlineService.vue')
      },

      {
        path: 'address',
        component: () => import('../views/userCenter/address.vue')
      },

      {
        path: 'toBeLaunched',
        component: () => import('../views/userCenter/toBeLaunched.vue')
      },

      {
        path: 'invoiceManage',
        component: () => import('../views/userCenter/invoiceManage.vue')
      },

      {
        path: 'addInvoice',
        component: () => import('../views/userCenter/addInvoice.vue')
      },

      {
        path: 'invoiceDetail',
        component: () => import('../views/userCenter/invoiceDetail.vue')
      }
    ]
  },

  {
    path: '/createOrder',
    component: () => import('../views/createOrder.vue')
  },

  {
    path: '/goodsDetail',
    component: () => import('../views/goodsDetail.vue')
  },

  {
    path: '/payOrder',
    component: () => import('../views/payOrder.vue')
  },
  
  {
    path: '/orderDetail',
    component: () => import('../views/orderDetail.vue')
  },
  {
    path: '/userInvodice',
    component: () => import('../views/userCenter/userInvodice.vue')
  },
  {
    path: '/invoiceDetail',
    component: () => import('../views/userCenter/invoiceDetailV2.vue')
  },
  {
    path: '/orderDetailV2',
    component: () => import('../views/orderDetailV2.vue')
  },
  {
    path: '/addInvoiceV2',
    component: () => import('../views/userCenter/addInvoiceV2.vue')
  },
  {
    path: '/payOrderV2',
    component: () => import('../views/payOrderV2.vue')
  },
 
];

export const router = createRouter({
    // history: createWebHashHistory(),
    history: createWebHistory(),
    routes
});

// 路由拦截器--加载前
router.beforeEach((to,from,next) => {
  let { accesstoken, redirectUrl } = to.query;
  console.info(from);

  if (accesstoken) {
    request({
      url: `api/front/login/token/exchange`,
      method: 'post',
      data: {
        bcxToken: accesstoken
      }
    }).then(res => {
      let { code, message, data } = res as any;

      if (code && code !== 200) {
        ElMessageBox.alert(message, '提示', {})
        .then(() => { })
        .catch(() => { });
        next();
        return;
      }

      let { token, nickName, phone, avatar } = data;
      localStorage.setItem('shop_token', token);
      localStorage.setItem('shop_user_info', JSON.stringify({nickName, phone, avatar}));

      if (to.path == '/autologin') {
        redirectUrl ? window.location.href = `${redirectUrl}?bcxToken=${token}` : router.push('/shop');
      }
      next();
    }).catch(err => {
        ElMessageBox.alert(err, '提示', {})
        .then(() => { })
        .catch(() => { });
        next();
    });  
  } else {
    next();
  }
})

