import { createApp } from 'vue';
import './style.css';
import App from './App.vue';
import pinia from './store';
import { router } from './router/index';
import ElementPlus from 'element-plus';
import 'element-plus/dist/index.css';
import * as ElementPlusIconsVue from '@element-plus/icons-vue';

const app = createApp(App);
// 全局注册Element Icons
for (const [key, component] of Object.entries(ElementPlusIconsVue)) {
  app.component(key, component);
}
app.use(pinia).use(router).use(ElementPlus).mount('#app');
