/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.signature.util.ftp;

import com.bcxin.signature.config.FileWriteConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FtpWriteConnection {
    private static final Logger log = LoggerFactory.getLogger(FtpWriteConnection.class);
    private static final Logger logger = LoggerFactory.getLogger(FtpWriteConnection.class);
    private FTPClient ftp = new FTPClient();
    private boolean is_connected = false;

    public FtpWriteConnection() {
        this.ftp.setDefaultTimeout(FileWriteConfig.defaultTimeoutSecond * 1000);
        this.ftp.setConnectTimeout(FileWriteConfig.connectTimeoutSecond * 1000);
        this.ftp.setDataTimeout(FileWriteConfig.dataTimeoutSecond * 1000);
        try {
            this.initConnect(FileWriteConfig.getHost(), FileWriteConfig.getPort(), FileWriteConfig.getUserName(), FileWriteConfig.getPassword());
        }
        catch (IOException e) {
            logger.error("FtpWriteConnection \u521d\u59cb\u5316\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
    }

    private void initConnect(String host, int port, String user, String password) throws IOException {
        try {
            if (!this.ftp.isConnected()) {
                this.ftp.connect(host, port);
            }
        }
        catch (UnknownHostException ex) {
            throw new IOException("Can't find FTP server '" + host + "'");
        }
        this.ftp.enterLocalPassiveMode();
        int reply = this.ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            this.disconnect();
            throw new IOException("Can't connect to server '" + host + "'");
        }
        if (!this.ftp.login(user, password)) {
            this.is_connected = false;
            this.disconnect();
            throw new IOException("Can't login to server '" + host + "'");
        }
        this.is_connected = true;
    }

    public static boolean hasChineseUsingRegex(String str) {
        return str.matches(".*[\u4e00-\u9fa5]+.*");
    }

    public boolean uploadBase64(String path, String ftpFileName, String base64Content) throws IOException {
        boolean is = false;
        if (base64Content == null || base64Content.isEmpty()) {
            logger.error("fail to upload out file({}) with base64Content empty", (Object)ftpFileName);
            throw new IOException("Can't upload. The base64 content is empty.");
        }
        FtpWriteConnection.conv((String)path, (String)ftpFileName);
        if (FtpWriteConnection.hasChineseUsingRegex((String)ftpFileName)) {
            logger.error("fail to upload out file({}) with hasChineseUsingRegex", (Object)ftpFileName);
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            path = new String(path.getBytes("GBK"), "iso-8859-1");
            this.setWorkingDirectory(path);
        }
        ftpFileName = new String(ftpFileName.getBytes("GBK"), "iso-8859-1");
        byte[] decodedBytes = base64Content.getBytes();
        if (!this.ftp.isConnected()) {
            this.initConnect(FileWriteConfig.getHost(), FileWriteConfig.getPort(), FileWriteConfig.getUserName(), FileWriteConfig.getPassword());
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(decodedBytes);){
            String filePath = path + "/" + ftpFileName;
            filePath = filePath.replace("\\", "/");
            this.ftp.setFileType(2);
            is = this.ftp.storeFile(filePath, (InputStream)in);
            logger.error("success to upload out file(rt:{}-size={}byte):{}", new Object[]{is, decodedBytes.length, ftpFileName});
        }
        catch (Exception e) {
            logger.error("fail to upload out file uploadBase64 exception:{}-{}", new Object[]{path, ftpFileName, e});
        }
        return is;
    }

    private static void conv(String path, String ftpFileName) {
        ftpFileName = ftpFileName.startsWith("/") ? ftpFileName : "/" + ftpFileName;
        Path sourcePath = Paths.get(path + ftpFileName, new String[0]);
        if (sourcePath.getParent() != null) {
            path = sourcePath.getParent().toAbsolutePath().toString();
        }
        ftpFileName = sourcePath.getFileName().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> fileNames(String path, String keywork) throws IOException {
        if (StringUtils.isEmpty((CharSequence)keywork)) {
            keywork = "IN-";
        }
        StringBuilder sb = new StringBuilder();
        try {
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                path = new String(path.getBytes("GBK"), "iso-8859-1");
                sb.append("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6587\u4ef6\u4e1a\u52a1\u8282\u70b9\uff1a001<=======");
                this.setWorkingDirectory(path);
            }
            sb.append("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6587\u4ef6\u4e1a\u52a1,ftp\u8def\u5f84\uff1a" + path + ",\u5173\u952e\u5b57\uff1a" + keywork + "<=======");
            ArrayList<String> recentFiles = new ArrayList<String>();
            FTPFile[] files = this.ftp.listFiles();
            sb.append(String.format("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6587\u4ef6\u4e1a\u52a1\u8282\u70b9\uff1a003<=======:\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6587\u4ef6\u7684\u6570\u91cf size=%s", files.length));
            long currentTime = System.currentTimeMillis();
            long fiveMinutesAgo = currentTime - 300000L;
            for (FTPFile file : files) {
                Long fileTime = file.getTimestamp().getTimeInMillis() + (long)file.getTimestamp().getTimeZone().getOffset(0L);
                if (file.isFile() && fileTime >= fiveMinutesAgo && file.getName().startsWith(keywork)) {
                    sb.append(String.format("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6587\u4ef6\u4e1a\u52a1\u6709\u6548\u6587\u4ef6\u540d\uff1a%s<=======", file.getName()));
                    recentFiles.add(file.getName());
                    continue;
                }
                sb.append(String.format("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6587\u4ef6\u4e1a\u52a1\u6709\u6548\u6587\u4ef6\u540d-->\u4e0d\u7b26\u5408\uff1a%s<=======", file.getName()));
            }
            sb.append(String.format("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6700\u8fd15\u5206\u949f\u5185\u751f\u6210\u7684\u6587\u4ef6\u7684\u6570\u91cf\uff1a%s<=======", recentFiles.size()));
            ArrayList<String> arrayList = recentFiles;
            return arrayList;
        }
        finally {
            logger.error("fileNames \u8ddf\u8e2a\u4fe1\u606f:{}", (Object)sb);
        }
    }

    public void disconnect() throws IOException {
        if (this.ftp.isConnected()) {
            try {
                this.ftp.logout();
            }
            catch (IOException ex) {
                logger.error("disconnect\u65ad\u5f00\u8fde\u63a5\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            }
            try {
                this.ftp.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.is_connected = false;
        }
    }

    private boolean setWorkingDirectory(String dir) {
        if (!this.is_connected) {
            return false;
        }
        try {
            if (this.createDirecroty(dir)) {
                return this.ftp.changeWorkingDirectory(dir);
            }
        }
        catch (IOException e) {
            logger.error("setWorkingDirectory\u65ad\u5f00\u8fde\u63a5\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    public boolean isConnected() {
        return this.is_connected;
    }

    private boolean createDirecroty(String remote) throws IOException {
        boolean success;
        block3: {
            if (StringUtils.isEmpty((CharSequence)remote)) {
                return false;
            }
            success = true;
            String directory = remote.substring(0, remote.lastIndexOf("/") + 1);
            if (directory.equalsIgnoreCase("/") || this.ftp.changeWorkingDirectory(new String(directory))) break block3;
            int start = 0;
            int end = 0;
            start = directory.startsWith("/") ? 1 : 0;
            end = directory.indexOf("/", start);
            do {
                String subDirectory;
                if (this.ftp.changeWorkingDirectory(subDirectory = new String(remote.substring(start, end)))) continue;
                if (this.ftp.makeDirectory(subDirectory)) {
                    this.ftp.changeWorkingDirectory(subDirectory);
                    continue;
                }
                log.error("mack directory error :/" + subDirectory);
                return false;
            } while ((end = directory.indexOf("/", start = end + 1)) > start);
        }
        return success;
    }
}

