package com.bcxin.backend.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.crypto.digest.SM3;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

import java.security.KeyPair;
import java.security.SecureRandom;
/**
 * 加密类
 */
public class SMEncryptUtil {

    private static final Logger logger = LoggerFactory.getLogger(SMEncryptUtil.class);

    private static KeyPair pair = SecureUtil.generateKeyPair("SM2");
    private static byte[] privateKeyByte = pair.getPrivate().getEncoded();
    private static byte[] publicKeyByte = pair.getPublic().getEncoded();

    /***
     * 私钥  用getKye生成 用于sm2解密
     */
    private static String privateKey = "MIGTAgEAMBMGByqGSM49AgEGCCqBHM9VAYItBHkwdwIBAQQg0r5KPFFoiqYMf4STZuz0z0rdcER5gixtFOerZ89yohugCgYIKoEcz1UBgi2hRANCAAQl8FS1pkCAIA7m9MephJ9EvBnpAczOSxis83ZdKPWw25qu08zxE2J1mrgQ/sGcJ3rpIzIoqAXGV7aNlrsoAGGi";
    /**
     * 公钥  用getKye生成 用于sm2加密
     */
    private static String publicKey = "MFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEJfBUtaZAgCAO5vTHqYSfRLwZ6QHMzksYrPN2XSj1sNuartPM8RNidZq4EP7BnCd66SMyKKgFxle2jZa7KABhog==";

    private static SecureRandom random = new SecureRandom();
    private static byte bytes[] = new byte[16]; // 128 bits are converted to 16 bytes;

    public static void SMEncryptUtil(String priKey, String pubKey) {
        if(!StringUtils.isEmpty(priKey)){
            privateKey=priKey;
        }
        if(!StringUtils.isEmpty(pubKey)){
            publicKey=pubKey;
        }
    }

    /***
     * sm2 加密类
     */
    private static SM2 sm2 = null;
    /***
     * md5加密盐值
     */
    private static final byte[] salt = {'o', 'c', 'e', 'a', 'n', 's', 'o', 'f', 't', '@', '1', '2', '3', '4', '5', '6'};

    /***
     * sm3 加密类
     */
    private static SM3 sm3 = SmUtil.sm3();

    //key必须是16字节，即128位
    final static String key = "rkBOgsG3mM9UjAtD";

    //指明加密算法和秘钥
    static SymmetricCrypto sm4;


    static {
        sm2 = SmUtil.sm2(privateKey, publicKey);
        sm3.setSalt(salt);
        //项目上可以采用这个预先生成一个
        //random.nextBytes(bytes);
        sm4 = new SymmetricCrypto("SM4/ECB/PKCS5Padding", key.getBytes());
    }

    /**
     * sm2加密
     *
     * @param text
     * @return
     */
    public static String sm2Encrypt(String text) {
        String encryptStr = "";
        if (StrUtil.isNotEmpty(text)) {
            try {
                encryptStr = sm2.encryptBcd(text, KeyType.PublicKey);
            } catch (Exception ex) {
                logger.error("encrypt content error:", ex);
            }
        }
        return encryptStr;
    }

    /**
     * sm2解密
     *
     * @param text
     * @return
     */
    public static String sm2Decrypt(String text) {
        String decryptStr = "";

        if (StrUtil.isNotEmpty(text)) {
            try {
                decryptStr = StrUtil.utf8Str(sm2.decryptFromBcd(text, KeyType.PrivateKey));
            } catch (Exception ex) {
                logger.error("decrypt content error:", ex);
            }
        }
        return decryptStr;
    }

    /**
     * sm3加密
     *
     * @param text
     * @return
     */
    public static String sm3Encrypt(String text) {
        String encryptStr = "";

        if (StrUtil.isNotEmpty(text)) {
            try {
                encryptStr = sm3.digestHex(text);
            } catch (Exception ex) {
                logger.error("encrypt content error:", ex);
            }
        }
        return encryptStr;
    }

    public static String sm4Encrypt(String text) {
        String encryptStr = "";
        if (StrUtil.isNotEmpty(text)) {
            try {
                encryptStr = sm4.encryptHex(text);
            } catch (Exception ex) {
                logger.error("encrypt content error:", ex);
            }
        }
        return encryptStr;
    }

    public static String sm4Decrypt(String text) {
        String encryptStr = "";
        if (StrUtil.isNotEmpty(text)) {
            try {
                encryptStr = sm4.decryptStr(text);
            } catch (Exception ex) {
                logger.error("encrypt content error:", ex);
            }
        }
        return encryptStr;
    }

    //	@SuppressWarnings("unused")
    private static void test() {

    }

    public static void main(String[] args) {

        JSONObject json = new JSONObject();
        json.put("clientId","nx_bjgj_test");
        json.put("secretId", SMEncryptUtil.sm3Encrypt("nxbjgjtest"));
        json.put("timestamp",System.currentTimeMillis()+"");
        String ret = HttpUtil.post("https://zwfw.gat.nx.gov.cn/osc-cs/docking/tsk-apply/res_token",json.toJSONString());
        System.out.println(ret);
//		test();
//		getKye();
    }
}