package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.syncs.services.CleanQueuesCacheService;
import org.springframework.stereotype.Component;


@Component
public class SyncCleanQueuesCacheTask extends TaskAbstract {


    private final CleanQueuesCacheService cleanQueuesCacheService;

    public SyncCleanQueuesCacheTask(CleanQueuesCacheService cleanQueuesCacheService) {

        this.cleanQueuesCacheService = cleanQueuesCacheService;
    }


    @Override
    protected void runCore() throws Exception {
        cleanQueuesCacheService.cleanQueuesCache();
    }

    @Override
    public String getTaskName() {
        return "sync.clean.queues.cache";
    }
}
