package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.signature.service.QzSignatureStrategy;
import com.bcxin.backend.domain.signature.service.QzSignatureStrategyFactory;
//import com.bcxin.backend.domain.signature.service.SignatureToPDFService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

/**
 * in目录下的文件是否在out目录下存在，存在就删除in目录对应文件
 */
@Component
@ConditionalOnProperty(prefix = "myapps.signature",name = "enable",havingValue = "true")
public class SignatureJobDelTask extends TaskAbstract{

    @Value("${myapps.signature.serverKey}")
    String serverKey;
//    private final SignatureToPDFService signatureToPDFService;
//
//    public SignatureJobDelTask(SignatureToPDFService signatureToPDFService) {
//        this.signatureToPDFService = signatureToPDFService;
//    }


    @Override
    protected void runCore() {
        QzSignatureStrategy qzSignatureStrategy = QzSignatureStrategyFactory.getBYServerKey(serverKey);
        qzSignatureStrategy.delInPDF();
//        signatureToPDFService.delInPDF();
    }

    @Override
    public String getTaskName() {
        return "execute.signature.pdf.job.del";
    }

}
