package com.bcxin.backend.pojo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

/**
 * 办件受理
 */
@Data
public class UpProAccept {


    /**
     * 受理时间,格式 yyyy-MM-dd HH:mm:ss
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    String acceptDate;

    /**
     * 申请时间, 格式
     *  yyyy-MM-dd HH:mm:ss
     */

    String applyDate;

    /**
     *
     */
    String handleUserName;


    /**
     * 申请类型   C.10
     */
    String applyType;


    /**
     * 申请人名称
     */
    String applyerName;


    /**
     * 申请人证件号码
     * 申请人证件号码可多个号码组合，用符号“^”隔开
     */
    String applyerPageCode;

    /**
     * 申请人证件类型
     * 申请人证件类型可多个证件类型组合，用符号“^”隔开。字典为“C.34证件类型”
     */
    String applyerPageType;

    /**
     * 申请人类型  C.11
     * 1	自然人
     * 2	企业法人
     * 3	事业法人
     * 4	社会组织法人
     * 5	非法人企业
     * 6	行政机关
     */
    String applyerType;

    /**
     * 行政区划代码    地区编码
     * 校验区划位数是不是12位数
     */
    String areaId;


    /**
     * 基本编码        事项编号
     */
    String catalogCode;


    /**
     * 同步类型, I：新增件， U：修改件
     */
    String cdOperation;


    /**
     * 记录创建时间yyyy-MM-dd-ss
     */
    String cdTime;


    /**
     * 联系人/代理人手机号   无
     */
    String contractMobile;

    /**
     * 数据来源 固定值：部门名称首字母+系统名称首字母，(下划线链接’_’) 所属部门+系统名称的首字母
     */
    String dataSource;


    /**
     * 企业名称（如果是法人事项，必填）
     */
    String enterpriseName;

    /**
     * 是否是事项库办件 1是, 0不是
     */
    String isItemBase;

    /**
     * module id
     */

    String localItemCode;

    //本地id
    String localProjectNo;

    //module id
    String localTaskCode;

    /**
     * 受理部门编码
     * 区划内实施主体统一社会信用代码（见.字典附件）编码+无
     */
    String orgCode;

    /**
     * 受理部门  部门名称
     */
    String orgName;

    /**
     * 办件编号(唯一编号)  本地id
     */
    String  projectNo;

    /**
     * 办件类型1 即办件 2 承诺件
     */
    String projectType;

    /**
     * 承诺办结时间, 格式 yyyy-MM-dd HH:mm:ss
     */
    String promiseDate;

    /**
     * 承诺时限, 最大5位数
     */
    String promiseTime;


    /**
     * 记录唯一标识 本地id
     */
    String rowGuid;


    /**
     * 实施编码   module id
     */
    String taskCode;

    /**
     * 事项名称
     * 政务服务事项的具体名称
     */
    String taskName;

    /**
     * 事项版本 1
     */
    String taskVersion;


    /**
     * 业务办理项编码  module id
     */
    String taskHandleItem;


    /**
     * 统一社会信用代码（企业必填）
     */
    String companyCode;


    /**
     * 受理人员id  民警ID
     */
    String handleUserId;

    /**
     * 事项id     module id /formid
     */
    String fileId;


    /**
     * 所属警钟
     */
    String pcc;

    /**
     * 所属系统      系统名称
     */
    String sys_name;

    /**
     * 所属系统级别  1
     */
    String sys_lev;

    /**
     * 事项model_id  module id
     */
    String model_id;




}
