package com.bcxin.backend.domain.system.dispatch.snapshots;

import com.google.common.base.Strings;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.StringUtils;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

@Getter
@Setter(AccessLevel.PUBLIC)
public class UserValueSnapshot extends ValueSnapshot {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    /**
     * id
     */
    private String id;
    /**
     * 用户名称
     */
    private String name;

    /**
     * 账号
     */
    public String loginName;

    /**
     * 密码
     */
    private String password;

    /**
     * 电话
     */
    private String telephone;
    /**
     * 邮箱
     */
    private String email;
    /**
     * 证件类型
     */
    private String certificateType;
    /**
     * 证件号码
     */
    private String certificateNo;
    /**
     * 认证状态
     */
    private String certificateStatus;
    /**
     * 人脸照片
     */
    private String faceImage;
    /**
     * 默认部门Id
     */
    private String defaultDepartId;
    /**
     * 所属企业
     */
    private String domainId;
    /**
     * 身份证人像面
     */
    private String idCardFrontUrl;
    /**
     * 身份证国徽面
     */
    private String idCardReverseUrl;

    /**
     * 是否离职, 不要同步到V5其他企业
     */
    public boolean IsDimission;

    /**
     * true: 域管理员
     */
    public String domainUser;

    /**
     * 是否为部门接口人
     * 是否可以作为部门负责人
     */
    public boolean liaisonOfficer;

    private String idNumber;

    private String idType;

    private int level;

    private boolean status;

    private Date birthdate;

    private Date entryDate;

    private Map<String,Object> extendMap;

    private Collection<String> selectedDepartIds;

    private int sex;

    private UserValueSnapshot() {

    }

    public String getConnectedSelectedDepartIds() {
        return String.join(",", getSelectedDepartIds());
    }

    /**
     * @param id
     * @param name              用户名称
     * @param telephone         账号
     * @param email             邮箱
     * @param certificateType   证件类型
     * @param certificateNo     证件号码
     * @param certificateStatus 认证状态
     * @param faceImage         人脸照片
     * @param domainId          所属企业
     * @param idCardFrontUrl    身份证人像面
     * @param idCardReverseUrl  身份证国徽面
     * @return
     */
    public static UserValueSnapshot create(String id, String name,
                                           String loginName,
                                           String password,
                                           String telephone,
                                           String email, String certificateType,
                                           String certificateNo,
                                           String certificateStatus,
                                           String faceImage,
                                           String defaultDepartId,
                                           String domainId, String idCardFrontUrl,
                                           String idCardReverseUrl,
                                           String idNumber,
                                           String idType,
                                           int level,
                                           Collection<String> selectedDepartIds,
                                           String resourcePrefix,
                                           Date entryDate,
                                           Map<String,Object> extendMap) {
        UserValueSnapshot userValueSnapshot = new UserValueSnapshot();
        userValueSnapshot.setId(id);
        userValueSnapshot.setName(name);
        userValueSnapshot.setTelephone(telephone);
        userValueSnapshot.setEmail(email);
        userValueSnapshot.setCertificateType(certificateType);
        userValueSnapshot.setCertificateNo(certificateNo);
        userValueSnapshot.setCertificateStatus(certificateStatus);

        userValueSnapshot.setIdCardFrontUrl(String.format("%s/%s", resourcePrefix, idCardFrontUrl));
        userValueSnapshot.setFaceImage(String.format("%s/%s", resourcePrefix, faceImage));
        userValueSnapshot.setDefaultDepartId(defaultDepartId);
        userValueSnapshot.setLoginName(loginName);
        userValueSnapshot.setPassword(password);

        userValueSnapshot.setDomainId(domainId);
        userValueSnapshot.setIdCardReverseUrl(String.format("%s/%s", resourcePrefix, idCardReverseUrl));

        userValueSnapshot.setIdNumber(idNumber);
        userValueSnapshot.setIdType(idType);
        userValueSnapshot.setLevel(level);
        userValueSnapshot.setSelectedDepartIds(selectedDepartIds);
        userValueSnapshot.setExtendMap(extendMap);

        if (entryDate == null) {
            entryDate = new Date();
        }
        userValueSnapshot.setEntryDate(entryDate);

        if (!Strings.isNullOrEmpty(userValueSnapshot.getCertificateNo()) &&
                userValueSnapshot.getCertificateNo().length() >= 17) {
            userValueSnapshot.setSex("1".equals(userValueSnapshot.getCertificateNo().substring(16, 17)) ? 1 : 2);
            userValueSnapshot.setBirthdate(getBirthdate(userValueSnapshot.getCertificateNo()));
        } else {
            userValueSnapshot.setSex(2);
        }

        return userValueSnapshot;
    }

    private static Date getBirthdate(String certificateNo) {
        if (StringUtils.isEmpty(certificateNo) || certificateNo.length() < 14) {
            return null;
        }

        try {
            String date = String.format("%s-%s-%s", certificateNo.substring(6, 10), certificateNo.substring(11, 12), certificateNo.substring(13, 14));

            return dateFormat.parse(date);
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        return null;
    }

    public int getCertificateStatusValue() {
        if (StringUtils.isEmpty(this.certificateStatus)) {
            return 0;
        }

        switch (this.certificateStatus) {
            case "已认证":
                return 1;
            case "认证失败":
                return 3;
            case "认证中":
                return 2;
            default:
                return 0;
                /*
            case "未认证":
                return 0;
                 */
        }
    }

    //居民身份证;香港特区护照/身份证明;澳门特区护照/身份证明;台湾居民来往大陆通行证;外国人护照
    public String getCertificateTypeValue() {
        if(StringUtils.isEmpty(this.getCertificateType())) {
            return this.getCertificateType();
        }

        switch (this.getCertificateType()) {
            case "居民身份证":
            case "居民身份证（户口簿）":
                return "1";
            case "中国人民解放军军官证":
                return "2";
            case "中国人民武装警察警官证":
                return "3";
            case "香港特区护照":
            case "香港特区护照/身份证明":
                return "4";
            case "澳门特区护照":
            case "澳门特区护照/身份证明":
                return "5";
            case "台湾居民来往大陆通行证":
                return "6";
            case "外国人护照":
                return "8";
            default:
                return this.getCertificateType();
        }
    }

    public String getBirthdateText() {
        if (getBirthdate() == null) {
            return null;
        }

        return dateFormat.format(getBirthdate());
    }

    public String getEntryDateText() {
        if (getEntryDate() == null) {
            return null;
        }

        return dateFormat.format(getEntryDate());
    }

    @Override
    protected PriorityValue getPriority() {
        return PriorityValue.User;
    }
}
