package com.bcxin.backend.domain.enums;

public enum EventType implements EnumValue {
    Created(0, "新增"),
    Edited(1, "修改"),
    Deleted(2, "删除");

    private final int value;
    private final String desc;

    EventType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }
}
