/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.screening.service.impl;

import com.bcxin.backend.core.exceptions.SaasBadException;
import com.bcxin.backend.domain.models.Result;
import com.bcxin.backend.domain.models.ScreeningDTO;
import com.bcxin.backend.domain.screening.factory.ScreeningFactory;
import com.bcxin.backend.domain.screening.service.impl.BgUser;
import com.bcxin.backend.domain.screening.service.impl.PersonInfor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public abstract class BackgroundScreeningServiceAbstractImpl {
    private static final Logger log = LoggerFactory.getLogger(BackgroundScreeningServiceAbstractImpl.class);
    private static Logger logger = LoggerFactory.getLogger(BackgroundScreeningServiceAbstractImpl.class);
    private final ScreeningFactory screeningFactory;
    @Autowired
    @Qualifier(value="primaryJdbcTemplate")
    protected JdbcTemplate jdbcTemplate;
    private String jobSql = "SELECT tm.ID sId,bsr.pkId as pkId,bs.user_id userId,bs.idnum idCard, tm.domainid,tm.item_domain_id domain_id,tm.item_companyName companyName,tm.ITEM_entryDate entryTime,tm.ITEM_phone phone,tm.ITEM_securityName userName,bs.background_screening_status screening,bsr.QUESTIONTYPE questiontype ,(SELECT ifnull(ts.ITEM_registerPoliceAddress,'') FROM tlk_setsupervise ts WHERE ts.item_domain_id = tm.ITEM_DOMAIN_ID limit 1)  as registerPoliceAddress ,(SELECT ifnull(ts.ITEM_registerPoliceAddressID,'') FROM tlk_setsupervise ts WHERE ts.item_domain_id = tm.ITEM_DOMAIN_ID limit 1)  as registerPoliceAddressID FROM tlk_securityman tm INNER JOIN bg_screening_users bs ON LEFT(tm.ID,LENGTH(bs.user_id)) = bs.user_id AND bs.enabled=1 AND bs.idnum IN ${idnums} LEFT JOIN bg_screening_user_results bsr ON bsr.domain_id=tm.item_domain_id AND bsr.USERID = bs.user_id AND bsr.DOCUMENTID=bs.idnum AND bsr.Entry_Time=tm.ITEM_entryDate WHERE tm.ITEM_isInMyCompany= 1 ;";

    protected BackgroundScreeningServiceAbstractImpl(ScreeningFactory screeningFactory) {
        this.screeningFactory = screeningFactory;
    }

    public abstract String numSql();

    public Boolean screening() {
        logger.info("-----------------------------------------------\u80cc\u666f\u7b5b\u67e5\u7a0b\u5e8f\u5f00\u59cb\u6267\u884c--------------------------------------------------------------");
        logger.info("-----------------------------------------------\u7ec4\u88c5\u4eba\u5458\u4fe1\u606f\u5f00\u59cb\u6267\u884c--------------------------------------------------------------");
        try {
            Collection<BgUser> bgUsers = this.getPendingBgScreenUsers();
            logger.info("\u67e5\u8be2\u6570\u636e\u5e93\uff0c\u88ab\u7b5b\u4eba\u5458\u6761\u6570\uff1a" + bgUsers.size());
            if (!CollectionUtils.isEmpty(bgUsers)) {
                List<BgUser> limitBgUsers = Collections.synchronizedList(new ArrayList());
                for (BgUser bgUser : bgUsers) {
                    limitBgUsers.add(bgUser);
                    if (limitBgUsers.size() != 30) continue;
                    try {
                        this.check(limitBgUsers);
                    }
                    catch (Exception e) {
                        logger.error("\u5206\u9875\u80cc\u666f\u7b5b\u67e5check\u65b9\u6cd5\u8fd0\u884c\u5f02\u5e38:" + e.getMessage());
                    }
                    limitBgUsers = Collections.synchronizedList(new ArrayList());
                }
                if (limitBgUsers.size() > 0) {
                    try {
                        this.check(limitBgUsers);
                    }
                    catch (Exception e) {
                        logger.error("\u5206\u9875\u80cc\u666f\u7b5b\u67e5check\u65b9\u6cd5\u8fd0\u884c\u5f02\u5e38:" + e.getMessage());
                    }
                }
                return true;
            }
            logger.info("\u88ab\u7b5b\u4eba\u5458\u5217\u8868\u4e3a\u7a7a");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private Collection<BgUser> getPendingBgScreenUsers() {
        return this.jdbcTemplate.query(this.numSql(), (RowMapper)BeanPropertyRowMapper.newInstance(BgUser.class));
    }

    private Collection<PersonInfor> getPendingPersonInfors(Collection<String> idnums) {
        String sqlStr = this.jobSql.replace("${idnums}", idnums.toString().replace("[", "('").replace("]", "')").replace(",", "','").replace(" ", ""));
        System.err.println("=======> getPendingPersonInfors:" + sqlStr);
        return this.jdbcTemplate.query(sqlStr, (RowMapper)BeanPropertyRowMapper.newInstance(PersonInfor.class));
    }

    private Result<List<ScreeningDTO>> doExecute(Collection<String> idNums) {
        return this.screeningFactory.getBSPByType().screenings(idNums.toArray(new String[idNums.size()]));
    }

    @Transactional
    protected void check(Collection<BgUser> bgUsers) throws Exception {
        block9: {
            logger.info("-----------------------------------------------\u5bf9\u6bd4\u7a0b\u5e8f\u5f00\u59cb\u6267\u884c--------------------------------------------------------------");
            logger.info("-----------------------------------------------\u5bf9\u6bd4\u7a0b\u5e8f\u5f00\u59cb\u6267\u884c--------------------------------------------------------------");
            List<String> idnums = Collections.synchronizedList(new ArrayList());
            bgUsers.stream().forEach(bgUser -> idnums.add(bgUser.getIdnum()));
            try {
                Collection<PersonInfor> jobCollection = this.getPendingPersonInfors(idnums);
                if (jobCollection.size() == 0) {
                    System.err.println("====> \u80cc\u666f\u7b5b\u67e5\u7a0b\uff1ajobCollection=0,end!");
                    return;
                }
                logger.info("\u67e5\u8be2\u6570\u636e\u5e93\uff0c\u88ab\u7b5b\u4eba\u5458\u6761\u6570\uff1a" + jobCollection.size());
                Result<List<ScreeningDTO>> result = this.doExecute(idnums);
                if ("0".equals(result.getRetType())) {
                    if (result.getData() == null) {
                        throw new SaasBadException(String.format("BackgrounpScreening:Request interface message returns exception,ErrMsg:%s.", result.getMsg()));
                    }
                    List updateBsu0 = Collections.synchronizedList(new ArrayList());
                    List updateBsu1 = Collections.synchronizedList(new ArrayList());
                    List insertBsur = Collections.synchronizedList(new ArrayList());
                    List updateBsur = Collections.synchronizedList(new ArrayList());
                    result.getData().stream().forEach(screening -> {
                        List perFilter = jobCollection.stream().filter(person -> person.getIdCard().equals(screening.getIdnum())).collect(Collectors.toList());
                        if ("1".equals(screening.getIsProblem())) {
                            List updateFilter = perFilter.stream().filter(person -> !StringUtils.isEmpty((Object)person.getQuestiontype()) && person.getQuestiontype().equals(screening.getDetail())).collect(Collectors.toList());
                            if (updateFilter.size() == 0) {
                                List insertFilter = perFilter.stream().filter(person -> StringUtils.isEmpty((Object)person.getQuestiontype()) || !person.getQuestiontype().equals(screening.getDetail())).collect(Collectors.toList());
                                insertFilter.stream().forEach(personInfor -> personInfor.setQuestiontype(screening.getDetail()));
                                ArrayList collect = insertFilter.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PersonInfor>(Comparator.comparing(temp -> temp.getDomain_id() + ";" + temp.getEntryTime()))), ArrayList::new));
                                insertBsur.addAll(collect);
                            }
                            updateFilter.stream().forEach(personInfor -> updateBsur.add(personInfor.getPkId() + ""));
                            updateBsu1.add(screening.getIdnum());
                        } else {
                            updateBsu0.add(screening.getIdnum());
                        }
                    });
                    if (insertBsur.size() > 0) {
                        String DRUG = "\u5438\u6bd2";
                        String DRUG1 = "\u6212\u6bd2";
                        String ESCAPE = "\u5728\u9003";
                        StringBuilder sb = new StringBuilder();
                        List argList = Collections.synchronizedList(new ArrayList());
                        sb.append("INSERT INTO bg_screening_user_results (ID,TYPE,CREATED,lastmodified,firstcompareTime,COMPARETIME,DOMAINID,QUESTIONTYPE,USERID,SECURITYNAME,DOCUMENTID,PHONE,COMPANYNAME,DOMAIN_ID,REGISTERPOLICEADDRESS,REGISTERPOLICEADDRESSID,POLICESTATUS,WORKSTATUS,COMPANYSTATUS,Entry_Time,CAPTURESTATUS) values");
                        ((Stream)insertBsur.stream().parallel()).forEach(questionUser -> {
                            int qt = 3;
                            String cst = null;
                            if (!ObjectUtils.isEmpty((Object)questionUser.getQuestiontype()) && (questionUser.getQuestiontype().contains(DRUG) || questionUser.getQuestiontype().contains(DRUG1))) {
                                qt = 2;
                            } else if (!ObjectUtils.isEmpty((Object)questionUser.getQuestiontype()) && questionUser.getQuestiontype().contains(ESCAPE)) {
                                qt = 1;
                                cst = "0";
                            }
                            String eTime = "'" + questionUser.getEntryTime() + "'";
                            if (StringUtils.isEmpty((Object)questionUser.getEntryTime())) {
                                eTime = null;
                            }
                            String rpa = "'" + questionUser.getRegisterPoliceAddress() + "'";
                            if (StringUtils.isEmpty((Object)questionUser.getRegisterPoliceAddress())) {
                                rpa = null;
                            }
                            String rpai = "'" + questionUser.getRegisterPoliceAddressID() + "'";
                            if (StringUtils.isEmpty((Object)questionUser.getRegisterPoliceAddressID())) {
                                rpai = null;
                            }
                            String phone = "'" + questionUser.getPhone() + "'";
                            if (StringUtils.isEmpty((Object)questionUser.getPhone())) {
                                phone = null;
                            }
                            String cn = "'" + questionUser.getCompanyName() + "'";
                            if (StringUtils.isEmpty((Object)questionUser.getCompanyName())) {
                                cn = null;
                            }
                            String ui = "'" + questionUser.getUserId() + "'";
                            if (StringUtils.isEmpty((Object)questionUser.getUserId())) {
                                ui = null;
                            }
                            String un = "'" + questionUser.getUserName() + "'";
                            if (StringUtils.isEmpty((Object)questionUser.getUserName())) {
                                un = null;
                            }
                            String cid = "'" + questionUser.getDomain_id() + "'";
                            if (StringUtils.isEmpty((Object)questionUser.getDomain_id())) {
                                cid = null;
                            }
                            String sql = "( UUID_SHORT() ,'" + qt + "', NOW(),NOW(), NOW(), NOW(),'" + questionUser.getDomainid() + "' , '" + questionUser.getQuestiontype() + "'," + ui + "," + un + ",'" + questionUser.getIdCard() + "', " + phone + "," + cn + "," + cid + ", " + rpa + "," + rpai + ",0,1,0," + eTime + "," + cst + " )";
                            argList.add(sql);
                        });
                        sb.append(argList.stream().distinct().collect(Collectors.toList()).toString().replace("[", "").replace("]", ";"));
                        this.jdbcTemplate.update(sb.toString());
                    }
                    if (updateBsur.size() > 0) {
                        this.jdbcTemplate.update("UPDATE bg_screening_user_results SET `COMPARETIME`=NOW(), `lastmodified`=NOW() WHERE `pkId` in " + updateBsur.toString().replace("[", "('").replace("]", "')").replace(",", "','") + ";");
                    }
                    if (updateBsu1.size() > 0) {
                        String psql = updateBsu1.toString().replace("[", "('").replace("]", "')").replace(",", "','").replace(" ", "");
                        this.jdbcTemplate.update("UPDATE bg_screening_users SET `background_screening_status`='1', `last_compare_time`=NOW(), `last_background_screening_time`=NOW(), `last_modified_time`=NOW() WHERE `idnum` in " + psql + ";");
                    }
                    if (updateBsu0.size() > 0) {
                        String nopsql = updateBsu0.toString().replace("[", "('").replace("]", "')").replace(",", "','").replace(" ", "");
                        this.jdbcTemplate.update("UPDATE bg_screening_users SET `background_screening_status`='0', `last_compare_time`=NOW(), `last_background_screening_time`=NOW(), `last_modified_time`=NOW() WHERE `idnum` in " + nopsql + ";");
                    }
                    break block9;
                }
                throw new SaasBadException(String.format("BackgrounpScreening:Request interface failed,ErrMsg:%s.", result.getMsg()));
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u80cc\u666f\u7b5b\u67e5check\u65b9\u6cd5\u51fa\u73b0\u95ee\u9898:" + e.getMessage());
            }
        }
    }
}

