/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.auth.factory;

import com.bcxin.backend.core.exceptions.SaasBadException;
import com.bcxin.backend.domain.auth.service.AuthenticationService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AuthFactory {
    public Map<String, AuthenticationService> connectionMap;
    private final String serverKey;

    public AuthFactory(Map<String, AuthenticationService> connectionMap, @Value(value="${myapps.authentication.serverKey}") String serverKey) {
        this.connectionMap = connectionMap;
        this.serverKey = serverKey;
    }

    public AuthenticationService getAuthByType() {
        String type = StringUtils.isEmpty((Object)this.serverKey) ? "auth_common" : this.serverKey;
        AuthenticationService service = this.connectionMap.get(type);
        if (service == null) {
            throw new SaasBadException(String.format("RealNameAuthenticationType:%s dose not support", type));
        }
        return service;
    }
}

