/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.bcxin.backend.core.utils.FtpUtils;
import com.bcxin.backend.domain.configs.FileModeConfig;
import com.google.common.collect.Maps;
import com.openhtmltopdf.extend.FSSupplier;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.helper.W3CDom;
import org.jsoup.nodes.Document;
import org.springframework.core.io.ClassPathResource;

public class PDFUtils {
    private static Map<String, String> tempHtmlMap = Maps.newHashMap();
    private static FSSupplier<InputStream> fSSupplier = null;

    public static void generatePdfByOpenhtmltopdf(String tempUrl, String pdfPath, Object formData) throws IOException {
        String htmlContent = tempHtmlMap.get(tempUrl);
        if (StringUtils.isEmpty((CharSequence)htmlContent)) {
            htmlContent = HttpUtil.get((String)tempUrl);
            tempHtmlMap.put(tempUrl, htmlContent);
        }
        htmlContent = PDFUtils.format(htmlContent, formData);
        Document document = Jsoup.parse((String)htmlContent);
        document.outputSettings().syntax(Document.OutputSettings.Syntax.html);
        try (FileOutputStream os = new FileOutputStream(pdfPath);){
            PdfRendererBuilder builder = new PdfRendererBuilder();
            builder.withUri(pdfPath);
            builder.toStream((OutputStream)os);
            builder.withW3cDocument(new W3CDom().fromJsoup(document), "");
            builder.useFont(PDFUtils.getFSSupplier("STSongti-SC-Regular.TTF"), "STSongti-SC-Regular");
            builder.run();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("create openhtmltopdf failed!");
        }
    }

    private static String format(String content, Object formData) {
        JSONObject data = JSONObject.fromObject((Object)formData);
        String pattern = "\\$\\{(.+?)\\}";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(content);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String key = m.group(1);
            Object value = data.get(key);
            m.appendReplacement(sb, value == null ? "" : value.toString());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static FSSupplier<InputStream> getFSSupplier(final String path) {
        if (fSSupplier == null) {
            fSSupplier = new FSSupplier<InputStream>(){

                public InputStream supply() {
                    try {
                        ClassPathResource resource = new ClassPathResource(path);
                        return resource.getInputStream();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            };
        }
        return fSSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadFtpFile(String pdfPath, String rootPath) {
        String outFilePath = rootPath + pdfPath;
        String inFilePath = rootPath + pdfPath.replace("/out", "/in");
        File outFile = new File(outFilePath);
        File inFile = new File(inFilePath);
        File[] fo = outFile.listFiles();
        ArrayList<String> successList = new ArrayList<String>();
        ArrayList<String> failList = new ArrayList<String>();
        if (fo.length == 0) {
            return null;
        }
        JSONObject json = new JSONObject();
        try {
            for (File file : fo) {
                try (FileInputStream fis = new FileInputStream(file);){
                    boolean uploadResult = FtpUtils.bcxUploadFile((String)FileModeConfig.getHost(), (String)FileModeConfig.getUserName(), (String)FileModeConfig.getPassword(), (int)FileModeConfig.getPort(), (String)((StrUtil.isEmpty((CharSequence)FileModeConfig.getFilePath()) ? "" : FileModeConfig.getFilePath()) + "/uploads/" + pdfPath.split("/uploads/")[1]), (InputStream)fis);
                    if (!uploadResult) {
                        System.err.println("=======>\u4e0a\u4f20ftp\u5931\u8d25\uff1a" + file.getName() + "<=======");
                        failList.add(file.getName());
                        continue;
                    }
                    successList.add(file.getName());
                }
                catch (IOException e) {
                    System.err.println("=======>\u4e0a\u4f20ftp\u5f02\u5e38\uff1a" + file.getName() + "\uff0cERR\uff1a" + e.getMessage() + "<=======");
                    failList.add(file.getName());
                }
            }
            String successFile = String.join((CharSequence)",", successList);
            String failFile = String.join((CharSequence)",", failList);
            json.put((Object)"success", (Object)successFile);
            json.put((Object)"fail", (Object)failFile);
        }
        catch (Exception e) {
            System.err.println("=======>\u4e0a\u4f20ftp\u5931\u8d25\u4e86<=======");
        }
        finally {
            try {
                FileUtils.cleanDirectory((File)inFile);
                FileUtils.cleanDirectory((File)outFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return json.toString();
    }
}

