/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.hibernateplus.utils;

import com.bcxin.risk.hibernateplus.entity.Convert;
import com.bcxin.risk.hibernateplus.utils.MapUtils;
import com.bcxin.risk.hibernateplus.utils.SqlUtils;
import com.bcxin.risk.hibernateplus.utils.StringUtils;
import com.bcxin.risk.hibernateplus.utils.TypeConvert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jboss.logging.Logger;

public class HibernateUtils {
    private static final Logger logger = Logger.getLogger(HibernateUtils.class);
    private static final String BASE_COUNT = "SELECT COUNT(0) FROM ";
    private static final String BASE_LIST = " FROM ";

    public static String getListHql(Class clazz) {
        return HibernateUtils.getListHql(clazz, Collections.EMPTY_MAP);
    }

    private static StringBuilder getBaseListHql(Class clazz) {
        return HibernateUtils.getBaseHql(clazz, BASE_LIST);
    }

    private static StringBuilder getBaseHql(Class clazz, String baseHql) {
        StringBuilder builder = new StringBuilder(baseHql);
        builder.append(clazz.getSimpleName());
        return builder;
    }

    public static String getListHql(Class clazz, Map<String, Object> params) {
        return HibernateUtils.getListHql("", clazz, params);
    }

    public static String getListHql(String order, Class clazz, Map<String, Object> params) {
        StringBuilder builder = HibernateUtils.getBaseListHql(clazz);
        HibernateUtils.getWhere(builder, params);
        HibernateUtils.getOrderby(order, builder);
        return builder.toString();
    }

    private static void getOrderby(String order, StringBuilder builder) {
        if (StringUtils.isNotBlank(order)) {
            builder.append(" ORDER BY ");
            builder.append(order);
        }
    }

    private static StringBuilder getBaseCountHql(Class clazz) {
        return HibernateUtils.getBaseHql(clazz, BASE_COUNT);
    }

    public static String getCountHql(Class clazz, Map<String, Object> params) {
        StringBuilder builder = HibernateUtils.getBaseCountHql(clazz);
        HibernateUtils.getWhere(builder, params);
        return builder.toString();
    }

    private static void getWhere(StringBuilder builder, Map<String, Object> params) {
        if (MapUtils.isNotEmpty(params)) {
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(params.keySet());
            builder.append(" WHERE ");
            for (int i = 0; i < list.size(); ++i) {
                String property = (String)list.get(i);
                Object value = params.get(property);
                builder.append(property);
                if (i == list.size() - 1) {
                    HibernateUtils.setByMap(builder, property, value);
                    continue;
                }
                HibernateUtils.setAndByMap(builder, property, value);
            }
        }
    }

    private static void setByMap(StringBuilder builder, String property, Object object) {
        if (object.getClass().isArray() || object instanceof List) {
            builder.append(" IN ");
        } else {
            builder.append(" = ");
        }
        builder.append(":");
        builder.append(property);
    }

    private static void setAndByMap(StringBuilder builder, String property, Object object) {
        if (object.getClass().isArray() || object instanceof List) {
            builder.append(" IN ");
        } else {
            builder.append(" = ");
        }
        builder.append(":");
        builder.append(property);
        builder.append(" AND ");
    }

    public static void setParams(Query query, String key, Object obj) {
        if (obj.getClass().isArray()) {
            query.setParameterList(key, (Object[])obj);
        } else if (obj instanceof List) {
            query.setParameterList(key, (Collection)((List)obj));
        } else {
            query.setParameter(key, obj);
        }
    }

    public static void setPage(int page, int rows, Query query) {
        if (0 != rows) {
            page = TypeConvert.toInteger(page, 1);
            query.setFirstResult((page - 1) * rows).setMaxResults(rows);
        }
    }

    public static Query getEntitySqlQuery(Class<? extends Convert> cls, String sql, SessionFactory factory, Boolean isCurrent) {
        return HibernateUtils.getSqlQuery(cls, sql, factory, isCurrent);
    }

    public static Query getSqlQuery(Class<? extends Convert> cls, String sql, SessionFactory factory, Boolean isCurrent) {
        System.err.println("Execute SQL\uff1a" + SqlUtils.sqlFormat(sql, true));
        SQLQuery sqlQuery = HibernateUtils.getSession(factory, isCurrent).createSQLQuery(sql);
        if (cls != null) {
            sqlQuery.addEntity(cls);
        }
        return sqlQuery;
    }

    public static Query getSqlQuery(String sql, SessionFactory factory, Boolean isCurrent) {
        return HibernateUtils.getSqlQuery(null, sql, factory, isCurrent);
    }

    public static Query getHqlQuery(String hql, SessionFactory factory, Boolean isCurrent) {
        System.err.println("Execute HQL\uff1a" + SqlUtils.sqlFormat(hql, true));
        return HibernateUtils.getSession(factory, isCurrent).createQuery(hql);
    }

    public static Session getSession(SessionFactory factory, Boolean isCurrent) {
        return isCurrent != false ? factory.getCurrentSession() : factory.openSession();
    }
}

