package com.bcxin.risk.mybatis.activity;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import lombok.Data;

import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 报告所选择的服务机构，合作的价格
 * @author luopeng
 *
 */
@TableName("RISK_Activity_Cooper")
@Data
public class ActivityCooperM extends Model<ActivityCooperM> {

	private static final long serialVersionUID = 1L;

	@TableId
	private Long oid;

	private Long activity_id;
	
	private Long org_id;
	
	private BigDecimal amount = BigDecimal.ZERO;
	
	/**
	 * 创建时间
	 */
	@Temporal(TemporalType.TIMESTAMP)
	private Date createOn;

	/**
	 * 修改时间
	 */
	@Temporal(TemporalType.TIMESTAMP)
	private Date updateOn;

	@Override
	protected Serializable pkVal() {
		return this.getOid();
	}
}
