package com.bcxin.risk.user.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 权限表
 */
@Entity
@Table(name = "RISK_Role_Menu")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class RoleMenu extends BaseBean {

	private static final long serialVersionUID = 1L;

//	@ManyToOne(targetEntity = Role.class, fetch = FetchType.LAZY)
//	@JoinColumn(name = "role_id")
//	private Role role; //所属角色
//
//	@ManyToOne(targetEntity = Menu.class, fetch = FetchType.LAZY)
//	@JoinColumn(name = "menu_id")
//	private Menu menu; //所属菜单

	private Long role_id;

	private Long menu_id;


	// 重写equals方法
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final RoleMenu other = (RoleMenu) obj;
		if(this.getMenu_id()!=other.getMenu_id())
			return false;
		return true;
	}

}
