package com.bcxin.risk.user.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 角色
 */
@Entity
@Table(name = "RISK_Role")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class Role extends BaseBean {

	private static final long serialVersionUID = 1L;

	private String roleCode;
	
	private String roleName;

	private String roleDesc;

	private String orgType; //机构类型（字典）

	private String serviceOrgType; //第三方服务机构机构类型（字典）
	
	private String active;  //激活状态，1代表有效，0代表无效（字典）

}
