package com.bcxin.risk.user.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 菜单
 */
@Entity
@Table(name = "RISK_Menu")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class Menu extends BaseBean {

	private static final long serialVersionUID = 1L;

	@ManyToOne(targetEntity = Menu.class, fetch = FetchType.EAGER)
	@JoinColumn(name = "parent_id")
	private Menu parent;

	private String menuCode;//编码规则 01 0101 010101
	
	private String menuName;

	private String menuDesc;

	private String menuType;
	
}
