package com.bcxin.risk.user.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 专家工作区域表
 */
@Entity
@Table(name = "risk_expert_region")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class ExpertRegion extends BaseBean {

    private static final long serialVersionUID = 1L;

    private Long user_id; //对应用户

    private Long region_id; //具体省市县id

    private String region_level; //区域级别

}
