package com.bcxin.risk.sys;


import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import com.bcxin.risk.order.Transaction;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;

import com.bcxin.risk.base.domain.BaseBean;

/**
 * 交易，存储交易报文
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_BusinessRequest")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class BusinessRequest extends BaseBean {
	
	private static final long serialVersionUID = 1L;

	@Type(type = "text")
	private String requestMessage;//请求报文
	
	@Type(type = "text")
	private String responseMessage;//返回报文
	
	
	@OneToOne(targetEntity = Transaction.class, cascade = CascadeType.ALL)
	@JoinColumn(name = "transaction_id")
	private Transaction transaction = new Transaction();//保单交易
	
	private String businessCode;
	
}
