package com.bcxin.risk.surveytk.domain.dto;

import com.bcxin.risk.base.domain.util.StringUtil;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * @author hzp
 * 踏勘阶段整改信息
 */
@Data
public class SurveyStepReformDataDto implements Serializable {
    /**
     * 踏勘计划id
     */
    private String planId;

    private String surveyTaskId;
    /**
     * 踏勘问卷id
     */
    private String questionnaireId;

    private String surveyStep;

    /**
     * 整改意见id
     */
    private String reformId;
    /**
     * 承办方整改意见回复
     */
    private String reformSuggest;

    /**
     * 承办方后回复的整改图片
     */
    private List<String> reformPhotoList;

    /**
     * 现场图片
     */
    private List<String> photoList;

    /**
     * 整改意见
     */
    private String answerSuggest;

    public SurveyStepReformDataDto(){

    }

    public SurveyStepReformDataDto(Map<String,Object> map){
        // 计划id
        this.planId=safeTransFor(map.get("planId"));
        this.surveyTaskId=safeTransFor(map.get("surveyTaskId"));
        // 整改意见id
        this.reformId=safeTransFor(map.get("reformId"));
        this.surveyStep=safeTransFor(map.get("surveyStep"));
        // 问卷id
        this.questionnaireId=safeTransFor(map.get("questionnaireId"));
        // 踏勘整改意见
        this.answerSuggest=safeTransFor(map.get("tkResult"));
        // 回复的整改信息
        this.reformSuggest=safeTransFor(map.get("reformResult"));
        // 踏勘上传的图片
        String photo=safeTransFor(map.get("tkPhotos"));
        if(StringUtil.isNotEmpty(photo)) {
            this.photoList = Arrays.asList(photo.split(","));
        }
        // 整改回复图片
        String reformPhoto=safeTransFor(map.get("reformPhoto"));
        if(StringUtil.isNotEmpty(reformPhoto)){
            this.reformPhotoList=Arrays.asList(reformPhoto.split(","));
        }
    }

    private String safeTransFor(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }
}
