package com.bcxin.risk.surveytk.domain.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author hzp
 * 一个踏勘阶段 可以 对应多个踏勘计划，但是该阶段该场馆只有一个踏勘问卷
 * 一个踏勘问卷 可以 有多个整改意见id
 * 一个踏勘问卷 可以 对应多个踏勘计划
 */
@Data
public class SurveyDetailDto implements Serializable {

    /**
     * 问卷id
     */
    private Long questionId;

    /**
     * 踏勘报告
     */
    private String surveyReport;

    /**
     * 踏勘专家
     */
    private String tkExpert;

    /**
     * 踏勘计划
     */
    private List<SurveyStepDataDto> planList;

    /**
     * 踏勘意见
     */
    private List<SurveyStepReformDataDto> reformList;
}
