package com.bcxin.risk.survey.domain;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import com.bcxin.risk.user.domain.User;
import lombok.Data;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.report.enums.SurveyStep;
import com.bcxin.risk.report.enums.TaskStatus;

/**
 * 查勘反馈
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_Survey_FeedBack")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
public class Survey_FeedBack extends BaseBean{

	 
	private static final long serialVersionUID = 1L;

	@ManyToOne(targetEntity = SurveyTask.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "taskId")
	private SurveyTask surveyTask = new SurveyTask(); //对应勘查任务

	// 勘查员工号
	@ManyToOne(targetEntity = User.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "userId")
	private User user = new User();
	
	@Enumerated(EnumType.STRING)
	private SurveyStep surveyStep;//勘查阶段

	@ManyToMany(targetEntity = User.class, cascade = CascadeType.ALL, fetch = FetchType.LAZY)
	@JoinTable(name = "risk_feedBack_Expert",joinColumns = { @JoinColumn(name = "feedBackId") }, inverseJoinColumns = { @JoinColumn(name = "expertId") })
    private List<User> experts = new ArrayList<User>();

	//各勘查计划
	@OneToMany(targetEntity = SurveyPlan.class, cascade = CascadeType.REMOVE, mappedBy="feedBack", fetch = FetchType.LAZY)
    private List<SurveyPlan> surveyPlans = new ArrayList<SurveyPlan>();
    
	//各勘查项目明细
	@OneToMany(targetEntity = Survey_Questionnaire.class, cascade = CascadeType.REMOVE, mappedBy="feedBack", fetch = FetchType.LAZY)
    private List<Survey_Questionnaire> questionnaires = new ArrayList<Survey_Questionnaire>();
    	
	@Enumerated(EnumType.STRING)
	private TaskStatus taskStatus; // 状态
		
	private String remark;//备注


}
