package com.bcxin.risk.survey.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;

import javax.persistence.*;

/**
 * @author hzp
 * 踏勘阶段专家
 */
@Entity
@Table(name = "risk_survey_expert")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
public class SurveyExpert extends BaseBean {

    private static final long serialVersionUID = 1L;

    /**
     * 对应的任务
     */
    @JoinColumn(name = "taskId")
    private Long taskId;

    /**
     * 对应勘察任务
     */
    @JoinColumn(name = "surveyTaskId")
    private Long surveyTaskId;

    /**
     * 踏勘阶段
     */
    @JoinColumn(name = "surveyStep")
    private String surveyStep;

    /**
     * 勘查专家
     */
    @JoinColumn(name = "expertUserId")
    private Long expertUserId;

}
