package com.bcxin.risk.report.material.dto;

import lombok.Data;

import java.util.Map;

@Data
public class MaterialFormValueDTO {

    /**
     * 元素oid
     */
    private String attrId;

    /**
     * 元素代码
     */
    private String attrCode;

    /**
     * 元素名
     */
    private String attrName;

    /**
     * 元素类型
     */
    private String attrType;

    /**
     * 多选类型
     */
    private String optionType;

    /**
     * 值
     */
    private String value;


    public MaterialFormValueDTO(Map<String,Object> map){
        this.attrId = safeTransfor(map.get("oid"));
        this.attrCode = safeTransfor(map.get("attrCode"));
        this.attrName = safeTransfor(map.get("attrName"));
        this.attrType = safeTransfor(map.get("attrType"));
        this.optionType = safeTransfor(map.get("optionType"));
        this.value = safeTransfor(map.get("value"));
    }


    /**
     *
     * <b>Function 将Object安全转换为String</b>
     *
     * @param obj
     * @return
     * @author LuoPeng
     * @date 2016年12月22日 下午5:17:02
     * @注意事项 </b>
     * <b>
     */
    private String safeTransfor(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }
}
