package com.bcxin.risk.report.material.domain;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;


/**
 * 合同存证类
 *
 * @author xuerdong
 */
@Entity
@Table(name = "RISK_ContractEvidence")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class ContractEvidence extends BaseBean {
    //源压缩文件路径
    private String uploadPath;
    //存证函文件路径
    private String letterPath;
    private String fileId;

    @ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
    @JoinColumn(name = "activity_id")
    private Activity activity;

}
